/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.lstree;

import com.atlassian.bitbucket.scm.git.command.lstree.GitLsTreeBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitLsTreeBuilder
extends AbstractGitCommandBuilder<GitLsTreeBuilder>
implements GitLsTreeBuilder {
    private final Set<String> paths = new LinkedHashSet<String>();
    private boolean nullTerminated;
    private boolean recursive;
    private boolean sizes;
    private String tree;

    public DefaultGitLsTreeBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("ls-tree"));
    }

    @Nonnull
    public GitLsTreeBuilder clearPaths() {
        this.paths.clear();
        return this.self();
    }

    @Nonnull
    public GitLsTreeBuilder nullTerminated(boolean value) {
        this.nullTerminated = value;
        return this.self();
    }

    @Nonnull
    public DefaultGitLsTreeBuilder path(String path) {
        DefaultGitLsTreeBuilder.addIfNotBlank(this.paths, path);
        return this.self();
    }

    @Nonnull
    public GitLsTreeBuilder paths(String value, String ... values) {
        DefaultGitLsTreeBuilder.addIfNotBlank(this.paths, value, values);
        return this.self();
    }

    @Nonnull
    public GitLsTreeBuilder paths(Iterable<String> values) {
        DefaultGitLsTreeBuilder.addIfNotBlank(this.paths, values);
        return this.self();
    }

    @Nonnull
    public GitLsTreeBuilder recursive(boolean value) {
        this.recursive = value;
        return this.self();
    }

    @Nonnull
    public GitLsTreeBuilder sizes(boolean value) {
        this.sizes = value;
        return this.self();
    }

    @Nonnull
    public DefaultGitLsTreeBuilder tree(@Nonnull String value) {
        Objects.requireNonNull(value, "tree");
        this.tree = value.indexOf(58) == -1 ? this.checkNotBlank(value, "tree") : StringUtils.stripStart((String)value, null);
        return this.self();
    }

    @Nonnull
    public DefaultGitLsTreeBuilder tree(@Nonnull String rev, String file) {
        return this.tree(this.checkNotBlank(rev, "rev") + ":" + StringUtils.defaultString((String)file));
    }

    @Override
    protected void applyArguments() {
        if (this.nullTerminated) {
            this.builder.argument("-z");
        }
        if (this.recursive) {
            this.builder.argument("-r");
        }
        if (this.sizes) {
            this.builder.argument("-l");
        }
        ((GitFreeFormCommandBuilder)this.builder.treeish(this.tree)).argument("--");
        this.paths.forEach(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).rawArgument(arg_0));
    }

    @Override
    @Nonnull
    protected DefaultGitLsTreeBuilder self() {
        return this;
    }
}

