/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.merge;

import com.atlassian.bitbucket.scm.git.command.merge.GitMergeBaseBuilderSupport;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractGitMergeBaseBuilder<B extends GitMergeBaseBuilderSupport<B>>
extends AbstractGitCommandBuilder<B>
implements GitMergeBaseBuilderSupport<B> {
    protected final Set<String> commits = new LinkedHashSet<String>();

    protected AbstractGitMergeBaseBuilder(GitFreeFormCommandBuilder builder) {
        super(builder);
    }

    @Nonnull
    public B commit(String value) {
        AbstractGitMergeBaseBuilder.addIfNotBlank(this.commits, value);
        return (B)((GitMergeBaseBuilderSupport)this.self());
    }

    @Nonnull
    public B commits(Iterable<String> value) {
        AbstractGitMergeBaseBuilder.addIfNotBlank(this.commits, value);
        return (B)((GitMergeBaseBuilderSupport)this.self());
    }

    @Nonnull
    public B commits(String value, String ... values) {
        AbstractGitMergeBaseBuilder.addIfNotBlank(this.commits, value, values);
        return (B)((GitMergeBaseBuilderSupport)this.self());
    }

    @Override
    protected void applyArguments() {
        this.applyModeArguments();
        for (String commit : this.commits) {
            this.builder.commitish(commit);
        }
        if (this.commits.size() == 1) {
            String commitId = (String)Iterables.getOnlyElement(this.commits);
            this.builder.argument(commitId);
        }
    }

    protected abstract void applyModeArguments();
}

