/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.merge;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandErrorHandler;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.merge.GitMergeBuilderSupport;
import com.atlassian.bitbucket.scm.git.command.merge.GitMergeFastForward;
import com.atlassian.bitbucket.scm.git.command.merge.GitMergeVerify;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.merge.MergeCommandExitHandler;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public abstract class AbstractGitMergeBuilder<B extends GitMergeBuilderSupport<B>>
extends AbstractGitCommandBuilder<B>
implements GitMergeBuilderSupport<B> {
    protected final I18nService i18nService;
    protected final Repository repository;
    protected GitMergeFastForward ff;
    private boolean allowUnrelatedHistories;
    private String commit;
    private boolean quiet;
    private boolean useDefaultExitHandler;
    private GitMergeVerify verify;

    public AbstractGitMergeBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, Repository repository) {
        super((GitFreeFormCommandBuilder)builder.command("merge"));
        this.i18nService = i18nService;
        this.repository = repository;
        this.ff = GitMergeFastForward.DEFAULT;
        this.useDefaultExitHandler = true;
        this.verify = GitMergeVerify.DEFAULT;
    }

    @Nonnull
    public B allowUnrelatedHistories(boolean value) {
        this.allowUnrelatedHistories = value;
        return (B)((GitMergeBuilderSupport)this.self());
    }

    @Nonnull
    public GitCommand<Void> build() {
        return this.buildWithLoggingHandler();
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new MergeCommandExitHandler(this.i18nService, this.repository));
        }
        return super.build(outputHandler);
    }

    @Nonnull
    public B commit(String value) {
        this.commit = value;
        return (B)((GitMergeBuilderSupport)this.self());
    }

    @Override
    @Nonnull
    public B defaultExitHandler() {
        this.useDefaultExitHandler = true;
        return (B)((GitMergeBuilderSupport)this.self());
    }

    @Nonnull
    public B errorHandler(@Nonnull CommandErrorHandler value) {
        this.builder.errorHandler(value);
        return (B)((GitMergeBuilderSupport)this.self());
    }

    @Override
    @Nonnull
    public B exitHandler(@Nonnull CommandExitHandler value) {
        super.exitHandler(value);
        this.useDefaultExitHandler = false;
        return (B)((GitMergeBuilderSupport)this.self());
    }

    @Nonnull
    public B ff(GitMergeFastForward value) {
        this.ff = (GitMergeFastForward)MoreObjects.firstNonNull((Object)value, (Object)GitMergeFastForward.DEFAULT);
        return (B)((GitMergeBuilderSupport)this.self());
    }

    @Nonnull
    public B quiet(boolean value) {
        this.quiet = value;
        return (B)((GitMergeBuilderSupport)this.self());
    }

    @Nonnull
    public B verify(@Nonnull GitMergeVerify value) {
        this.verify = Objects.requireNonNull(value, "verify");
        return (B)((GitMergeBuilderSupport)this.self());
    }

    @Override
    protected void applyArguments() {
        if (this.allowUnrelatedHistories) {
            this.builder.argument("--allow-unrelated-histories");
        }
        if (this.quiet) {
            this.builder.argument("--quiet");
        }
        this.verify.getFlag().ifPresent(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).argument(arg_0));
        this.builder.commitish(this.commit);
    }
}

