/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.merge;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.merge.GitMergeBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.merge.AbstractGitMergeBuilder;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitMergeBuilder
extends AbstractGitMergeBuilder<GitMergeBuilder>
implements GitMergeBuilder {
    private int log;
    private String message;

    public DefaultGitMergeBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, Repository repository) {
        super(builder, i18nService, repository);
    }

    @Nonnull
    public GitMergeBuilder log(boolean value) {
        return this.log(value ? Integer.MAX_VALUE : 0);
    }

    @Nonnull
    public GitMergeBuilder log(int value) {
        this.log = value;
        return this.self();
    }

    @Nonnull
    public GitMergeBuilder message(String value) {
        this.message = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (StringUtils.isBlank((CharSequence)this.message)) {
            this.builder.argument("--no-edit");
        } else {
            ((GitFreeFormCommandBuilder)this.builder.argument("-m")).argument(this.message);
        }
        if (this.ff.isFlagged()) {
            this.builder.argument(this.ff.getFlag());
        }
        if (this.log > 0) {
            StringBuilder option = new StringBuilder("--log");
            if (this.log < Integer.MAX_VALUE) {
                option.append("=").append(this.log);
            }
            this.builder.argument(option.toString());
        } else {
            this.builder.argument("--no-log");
        }
        super.applyArguments();
    }

    @Override
    @Nonnull
    protected GitMergeBuilder self() {
        return this;
    }
}

