/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.merge;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import com.atlassian.bitbucket.scm.git.command.merge.GitNonFastForwardMergeRejectedException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeCommandExitHandler
extends GitCommandExitHandler {
    private static final String MESSAGE_NON_FAST_FORWARD = "fatal: Not possible to fast-forward, aborting.";
    private static final Pattern PATTERN_ADDINFO_CACHE_FAILED = Pattern.compile("error: addinfo_cache failed for path '(.+)'$");
    private static final Logger log = LoggerFactory.getLogger(MergeCommandExitHandler.class);

    public MergeCommandExitHandler(I18nService i18nService, Repository repository) {
        super(i18nService, repository);
    }

    protected void evaluateStdErr(String stdErr, String command) {
        String cleanedStdErr = ADVICE_PATTERN.matcher(stdErr).replaceAll("");
        if (MESSAGE_NON_FAST_FORWARD.equals(cleanedStdErr)) {
            throw new GitNonFastForwardMergeRejectedException(this.i18nService.createKeyedMessage("bitbucket.git.merge.rejected.nonfastforward", new Object[0]));
        }
        super.evaluateStdErr(stdErr, command);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isErrorOutput(String line) {
        if (line.startsWith("error")) {
            Matcher matcher = PATTERN_ADDINFO_CACHE_FAILED.matcher(line);
            if (!matcher.matches()) return true;
            log.debug("BUGCHECK: addinfo_cache failure for {} is being ignored", (Object)matcher.group(1));
            return false;
        } else {
            if (!line.startsWith("fatal") && !line.startsWith("usage:")) return false;
            return true;
        }
    }
}

