/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.mv;

import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.mv.GitMvBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitMvBuilder
extends AbstractGitCommandBuilder<GitMvBuilder>
implements GitMvBuilder {
    private final List<String> sources = new ArrayList<String>();
    private String destination;
    private boolean force;

    public DefaultGitMvBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("mv"));
    }

    @Nonnull
    public GitCommand<Void> build() {
        if (this.sources.isEmpty()) {
            throw new IllegalStateException("A source path is required");
        }
        if (StringUtils.isBlank((CharSequence)this.destination)) {
            throw new IllegalStateException("A destination path is required");
        }
        return this.buildWithLoggingHandler();
    }

    @Nonnull
    public GitMvBuilder clearSources() {
        this.sources.clear();
        return this.self();
    }

    @Nonnull
    public GitMvBuilder destination(@Nonnull String value) {
        this.destination = Objects.requireNonNull(value, "destination");
        return this.self();
    }

    @Nonnull
    public GitMvBuilder force(boolean value) {
        this.force = value;
        return this.self();
    }

    @Nonnull
    public GitMvBuilder source(@Nonnull String value) {
        this.sources.add(Objects.requireNonNull(value, "source"));
        return this.self();
    }

    @Nonnull
    public GitMvBuilder sources(@Nonnull Iterable<String> values) {
        for (String value : Objects.requireNonNull(values, "sources")) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            this.sources.add(value);
        }
        return this.self();
    }

    @Nonnull
    public GitMvBuilder sources(@Nonnull String value, String ... moreValues) {
        this.sources.add(Objects.requireNonNull(value, "source"));
        for (String extraValue : moreValues) {
            if (!StringUtils.isNotBlank((CharSequence)extraValue)) continue;
            this.sources.add(extraValue);
        }
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.force) {
            this.builder.argument("-f");
        }
        this.sources.forEach(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).argument(arg_0));
        this.builder.argument(this.destination);
    }

    @Override
    @Nonnull
    protected GitMvBuilder self() {
        return this;
    }
}

