/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.notes;

import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.notes.GitNotesAddBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.notes.AbstractGitNotesBuilder;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitNotesAddBuilder
extends AbstractGitNotesBuilder<GitNotesAddBuilder>
implements GitNotesAddBuilder {
    public static final String FILE_STD_IN = "-";
    private final List<String> messages = Lists.newArrayList();
    private String file;
    private boolean force;

    public DefaultGitNotesAddBuilder(@Nonnull GitFreeFormCommandBuilder builder, @Nonnull String object) {
        super(builder, object, "add");
    }

    @Nonnull
    public GitCommand<Void> build() {
        this.validateNoteIsSpecified();
        return this.buildWithLoggingHandler();
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        this.validateNoteIsSpecified();
        return super.build(outputHandler);
    }

    private void validateNoteIsSpecified() {
        if (StringUtils.isBlank((CharSequence)this.file) && this.messages.isEmpty()) {
            throw new IllegalStateException("A file or a message must be specified when adding a note");
        }
    }

    @Nonnull
    public GitNotesAddBuilder clearInputHandler() {
        this.builder.clearInputHandler();
        this.file = null;
        return this.self();
    }

    @Nonnull
    public GitNotesAddBuilder file(Path value) {
        return this.file(value == null ? null : value.toAbsolutePath().toString());
    }

    @Nonnull
    public GitNotesAddBuilder file(String value) {
        if (FILE_STD_IN.equals(value)) {
            throw new IllegalArgumentException("To use standard input, supply a CommandInputHandler");
        }
        this.maybeClearInputHandler();
        this.file = value;
        return this.self();
    }

    @Nonnull
    public GitNotesAddBuilder force(boolean value) {
        this.force = value;
        return this.self();
    }

    @Nonnull
    public GitNotesAddBuilder inputHandler(@Nonnull CommandInputHandler value) {
        this.builder.inputHandler(value);
        this.file = FILE_STD_IN;
        return this.self();
    }

    @Nonnull
    public GitNotesAddBuilder message(String value) {
        DefaultGitNotesAddBuilder.addIfNotBlank(this.messages, value);
        return this.self();
    }

    @Nonnull
    public GitNotesAddBuilder messages(Iterable<String> values) {
        DefaultGitNotesAddBuilder.addIfNotBlank(this.messages, values);
        return this.self();
    }

    @Nonnull
    public GitNotesAddBuilder messages(String value, String ... values) {
        DefaultGitNotesAddBuilder.addIfNotBlank(this.messages, value, values);
        return this.self();
    }

    @Override
    protected void applyOptions() {
        if (this.force) {
            this.builder.argument("-f");
        }
        if (this.file != null) {
            ((GitFreeFormCommandBuilder)this.builder.argument("-F")).argument(this.file);
        }
        for (String message : this.messages) {
            ((GitFreeFormCommandBuilder)this.builder.argument("-m")).argument(message);
        }
    }

    @Override
    @Nonnull
    protected GitNotesAddBuilder self() {
        return this;
    }

    private void maybeClearInputHandler() {
        if (FILE_STD_IN.equals(this.file)) {
            this.clearInputHandler();
        }
    }
}

