/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.packobjects;

import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.git.command.packobjects.GitPackObjectsBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitPackObjectsBuilder
extends AbstractGitCommandBuilder<GitPackObjectsBuilder>
implements GitPackObjectsBuilder {
    private boolean all;
    private String baseName;
    private boolean deltaBaseOffset;
    private boolean incremental;
    private boolean local;
    private boolean nonEmpty;
    private boolean revs;
    private boolean stdOut = true;
    private boolean thin;
    private boolean unpacked;

    public DefaultGitPackObjectsBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("pack-objects"));
    }

    @Nonnull
    public GitPackObjectsBuilder all(boolean value) {
        this.all = value;
        if (value) {
            this.revs = true;
            this.unpacked = false;
        }
        return this.self();
    }

    @Nonnull
    public GitPackObjectsBuilder baseName(String value) {
        this.baseName = StringUtils.trimToNull((String)value);
        this.stdOut = this.baseName == null;
        return this.self();
    }

    @Nonnull
    public GitPackObjectsBuilder deltaBaseOffset(boolean value) {
        this.deltaBaseOffset = value;
        return this.self();
    }

    @Nonnull
    public GitPackObjectsBuilder incremental(boolean value) {
        this.incremental = value;
        return this.self();
    }

    @Nonnull
    public GitPackObjectsBuilder inputHandler(CommandInputHandler inputHandler) {
        if (inputHandler == null) {
            this.builder.clearInputHandler();
        } else {
            this.builder.inputHandler(inputHandler);
        }
        return this.self();
    }

    @Nonnull
    public GitPackObjectsBuilder local(boolean value) {
        this.local = value;
        return this.self();
    }

    @Nonnull
    public GitPackObjectsBuilder nonEmpty(boolean value) {
        this.nonEmpty = value;
        return this.self();
    }

    @Nonnull
    public GitPackObjectsBuilder revs(boolean value) {
        this.revs = value;
        if (!value) {
            this.all = false;
            this.unpacked = false;
        }
        return this.self();
    }

    @Nonnull
    public GitPackObjectsBuilder thin(boolean value) {
        this.thin = value;
        return this.self();
    }

    @Nonnull
    public GitPackObjectsBuilder unpacked(boolean value) {
        this.unpacked = value;
        if (value) {
            this.all = false;
            this.revs = true;
        }
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.deltaBaseOffset) {
            this.builder.argument("--delta-base-offset");
        }
        if (this.nonEmpty) {
            this.builder.argument("--non-empty");
        }
        if (this.local) {
            this.builder.argument("--local");
        }
        if (this.incremental) {
            this.builder.argument("--incremental");
        }
        if (this.revs) {
            this.builder.argument("--revs");
            if (this.all) {
                this.builder.argument("--all");
            } else if (this.unpacked) {
                this.builder.argument("--unpacked");
            }
        }
        if (this.stdOut) {
            this.builder.argument("--stdout");
        } else {
            this.builder.argument(this.baseName);
        }
        if (this.thin) {
            this.builder.argument("--thin");
        }
    }

    @Override
    @Nonnull
    protected GitPackObjectsBuilder self() {
        return this;
    }
}

