/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.push;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandErrorHandler;
import com.atlassian.bitbucket.scm.git.command.push.GitPushBuilder;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitPushBuilder
extends AbstractGitCommandBuilder<GitPushBuilder>
implements GitPushBuilder {
    private final GitScmConfig config;
    private final List<String> refspecs;
    private boolean force;
    private boolean porcelain;
    private boolean progress;
    private boolean prune;
    private String repository;

    public DefaultGitPushBuilder(GitFreeFormCommandBuilder builder, GitScmConfig config) {
        super((GitFreeFormCommandBuilder)builder.command("push"));
        this.config = config;
        this.refspecs = new ArrayList<String>();
    }

    @Nonnull
    public GitPushBuilder errorHandler(@Nonnull CommandErrorHandler value) {
        this.builder.errorHandler(value);
        return this.self();
    }

    @Nonnull
    public GitPushBuilder force(boolean value) {
        this.force = value;
        return this.self();
    }

    @Nonnull
    public GitPushBuilder porcelain(boolean value) {
        this.porcelain = value;
        return this.self();
    }

    @Nonnull
    public GitPushBuilder progress(boolean value) {
        this.progress = value;
        return this.self();
    }

    @Nonnull
    public GitPushBuilder prune(boolean value) {
        this.prune = value;
        return this.self();
    }

    @Nonnull
    public GitPushBuilder refspec(String value) {
        return this.refspecs(value, new String[0]);
    }

    @Nonnull
    public GitPushBuilder refspecs(String value, String ... values) {
        DefaultGitPushBuilder.addIfNotBlank(this.refspecs, value, values);
        return this.self();
    }

    @Nonnull
    public GitPushBuilder refspecs(Iterable<String> values) {
        DefaultGitPushBuilder.addIfNotBlank(this.refspecs, values);
        return this.self();
    }

    @Nonnull
    public GitPushBuilder repository(Repository value) {
        return this.repository(value == null ? null : this.config.getRepositoryDir(value).toString());
    }

    @Nonnull
    public GitPushBuilder repository(String value) {
        this.repository = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.force) {
            this.builder.argument("--force");
        }
        if (this.prune) {
            this.builder.argument("--prune");
        }
        if (this.porcelain) {
            this.builder.argument("--porcelain");
        }
        if (this.progress) {
            this.builder.argument("--progress");
        }
        if (StringUtils.isNotBlank((CharSequence)this.repository)) {
            this.builder.argument(this.repository);
            for (String refspec : this.refspecs) {
                this.builder.argument(refspec);
            }
        }
    }

    @Override
    @Nonnull
    protected GitPushBuilder self() {
        return this;
    }
}

