/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.rebase;

import com.atlassian.bitbucket.scm.CommandErrorHandler;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.rebase.GitRebaseBuilder;
import com.atlassian.stash.internal.scm.git.command.rebase.GitRebaseStat;
import com.atlassian.stash.internal.scm.git.command.rebase.GitRebaseVerify;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitRebaseBuilder
extends AbstractGitCommandBuilder<GitRebaseBuilder>
implements GitRebaseBuilder {
    private String branch;
    private boolean force;
    private boolean keepEmpty;
    private String onto;
    private boolean quiet;
    private GitRebaseStat stat = GitRebaseStat.DEFAULT;
    private String upstream;
    private boolean verbose;
    private GitRebaseVerify verify = GitRebaseVerify.DEFAULT;

    public DefaultGitRebaseBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("rebase"));
    }

    @Override
    @Nonnull
    public GitRebaseBuilder branch(@Nullable String value) {
        this.branch = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRebaseBuilder errorHandler(@Nonnull CommandErrorHandler value) {
        this.builder.errorHandler(value);
        return this.self();
    }

    @Override
    @Nonnull
    public GitRebaseBuilder force(boolean value) {
        this.force = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRebaseBuilder keepEmpty(boolean value) {
        this.keepEmpty = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRebaseBuilder onto(@Nullable String value) {
        this.onto = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRebaseBuilder quiet(boolean value) {
        this.quiet = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRebaseBuilder stat(@Nonnull GitRebaseStat value) {
        this.stat = Objects.requireNonNull(value, "stat");
        return this.self();
    }

    @Override
    @Nonnull
    public GitRebaseBuilder upstream(@Nonnull String value) {
        this.upstream = this.checkNotBlank(value, "upstream");
        return this.self();
    }

    @Override
    @Nonnull
    public GitRebaseBuilder verbose(boolean value) {
        this.verbose = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRebaseBuilder verify(@Nonnull GitRebaseVerify value) {
        this.verify = Objects.requireNonNull(value, "verify");
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.force) {
            this.builder.argument("--force-rebase");
        }
        if (this.keepEmpty) {
            this.builder.argument("--keep-empty");
        }
        if (this.quiet) {
            this.builder.argument("-q");
        }
        this.stat.getFlag().ifPresent(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).argument(arg_0));
        if (this.verbose) {
            this.builder.argument("-v");
        }
        this.verify.getFlag().ifPresent(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).argument(arg_0));
        if (StringUtils.isNotBlank((CharSequence)this.onto)) {
            this.builder.argument("--onto");
            this.builder.commitish(this.onto);
        }
        this.builder.commitish(this.upstream);
        if (StringUtils.isNotBlank((CharSequence)this.branch)) {
            this.builder.commitish(this.branch);
        }
    }

    @Override
    @Nonnull
    protected GitRebaseBuilder self() {
        return this;
    }
}

