/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.remote;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.remote.GitRemote;
import com.atlassian.bitbucket.scm.git.command.remote.GitRemoteAddBuilder;
import com.atlassian.bitbucket.scm.git.command.remote.GitRemoteRmBuilder;
import com.atlassian.bitbucket.scm.git.command.remote.GitRemoteSetUrlBuilder;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.remote.DefaultGitRemoteAddBuilder;
import com.atlassian.stash.internal.scm.git.command.remote.DefaultGitRemoteRmBuilder;
import com.atlassian.stash.internal.scm.git.command.remote.DefaultGitRemoteSetUrlBuilder;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.Objects;

public class DefaultGitRemote
implements GitRemote {
    private final GitFreeFormCommandBuilder builder;
    private final GitScmConfig config;

    public DefaultGitRemote(GitFreeFormCommandBuilder builder, GitScmConfig config) {
        this.builder = (GitFreeFormCommandBuilder)builder.command("remote");
        this.config = config;
    }

    @Nonnull
    public GitRemoteAddBuilder add(@Nonnull String name, @Nonnull Path url) {
        return this.add(name, Objects.requireNonNull(url, "url").toAbsolutePath().toString());
    }

    @Nonnull
    public GitRemoteAddBuilder add(@Nonnull String name, @Nonnull String url) {
        return new DefaultGitRemoteAddBuilder(this.builder, name, url);
    }

    @Nonnull
    public GitRemoteAddBuilder add(@Nonnull String name, @Nonnull Repository repository) {
        return new DefaultGitRemoteAddBuilder(this.builder, name, this.config.getRepositoryDir(Objects.requireNonNull(repository, "repository")).toAbsolutePath().toString());
    }

    @Nonnull
    public GitRemoteRmBuilder rm(@Nonnull String name) {
        return new DefaultGitRemoteRmBuilder(this.builder, name);
    }

    @Nonnull
    public GitRemoteSetUrlBuilder setUrl(@Nonnull String name, @Nonnull Path newUrl) {
        return this.setUrl(name, Objects.requireNonNull(newUrl, "newUrl").toAbsolutePath().toString());
    }

    @Nonnull
    public GitRemoteSetUrlBuilder setUrl(@Nonnull String name, @Nonnull String newUrl) {
        return new DefaultGitRemoteSetUrlBuilder(this.builder, name, newUrl);
    }
}

