/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.repack;

import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.repack.GitRepackAll;
import com.atlassian.stash.internal.scm.git.command.repack.GitRepackBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class DefaultGitRepackBuilder
extends AbstractGitCommandBuilder<GitRepackBuilder>
implements GitRepackBuilder {
    private GitRepackAll all = GitRepackAll.DEFAULT;
    private int depth;
    private boolean local;
    private boolean keepUnreachable;
    private String maxPackSize;
    private boolean noReuseDeltas;
    private boolean noReuseObjects;
    private boolean noUpdateServerInfo;
    private boolean prune;
    private boolean quiet;
    private String unpackUnreachable;
    private int window;
    private int windowMemory;
    private boolean writeBitmapIndex;

    public DefaultGitRepackBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("repack"));
    }

    @Override
    @Nonnull
    public GitRepackBuilder all(@Nonnull GitRepackAll value) {
        this.all = Objects.requireNonNull(value, "all");
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder depth(int value) {
        this.depth = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder local(boolean value) {
        this.local = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder keepUnreachable(boolean value) {
        this.keepUnreachable = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder maxPackSize(String value) {
        this.maxPackSize = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder prune(boolean value) {
        this.prune = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder quiet(boolean value) {
        this.quiet = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder reuseDeltas(boolean value) {
        this.noReuseDeltas = !value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder reuseObjects(boolean value) {
        this.noReuseObjects = !value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder unpackUnreachable(@Nullable String value) {
        this.unpackUnreachable = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder updateServerInfo(boolean value) {
        this.noUpdateServerInfo = !value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder window(int value) {
        this.window = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder windowMemory(int value) {
        this.windowMemory = value;
        return this.self();
    }

    @Override
    @Nonnull
    public GitRepackBuilder writeBitmapIndex(boolean value) {
        this.writeBitmapIndex = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.all.isFlagged()) {
            this.builder.argument(this.all.getFlag());
        }
        if (this.prune) {
            this.builder.argument("-d");
        }
        if (this.local) {
            this.builder.argument("-l");
        }
        if (this.noReuseObjects) {
            this.builder.argument("-F");
        } else if (this.noReuseDeltas) {
            this.builder.argument("-f");
        }
        if (this.quiet) {
            this.builder.argument("-q");
        }
        if (this.noUpdateServerInfo) {
            this.builder.argument("-n");
        }
        if (this.window > 0) {
            this.builder.argument("--window=" + this.window);
        }
        if (this.depth > 0) {
            this.builder.argument("--depth=" + this.depth);
        }
        if (this.windowMemory > 0) {
            this.builder.argument("--windowMemory=" + this.window);
        }
        if (this.maxPackSize != null) {
            this.builder.argument("--max-pack-size=" + this.maxPackSize);
        }
        if (this.writeBitmapIndex) {
            this.builder.argument("--write-bitmap-index");
        }
        if (this.unpackUnreachable != null) {
            this.builder.argument("--unpack-unreachable=" + this.unpackUnreachable);
        }
        if (this.keepUnreachable) {
            this.builder.argument("--keep-unreachable");
        }
    }

    @Override
    @Nonnull
    protected GitRepackBuilder self() {
        return this;
    }
}

