/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.reset;

import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.reset.GitResetBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.reset.GitResetMode;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitResetBuilder
extends AbstractGitCommandBuilder<GitResetBuilder>
implements GitResetBuilder {
    private final Set<String> paths = new LinkedHashSet<String>();
    private GitResetMode mode;
    private String commit;
    private boolean quiet;

    public DefaultGitResetBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("reset"));
    }

    @Nonnull
    public GitCommand<Void> build() {
        return this.buildWithLoggingHandler();
    }

    @Nonnull
    public GitResetBuilder commit(String value) {
        this.commit = value;
        return this.self();
    }

    @Nonnull
    public GitResetBuilder hard() {
        this.mode = GitResetMode.HARD;
        return this;
    }

    @Nonnull
    public GitResetBuilder mixed() {
        this.mode = GitResetMode.MIXED;
        return this;
    }

    @Nonnull
    public GitResetBuilder path(String value) {
        DefaultGitResetBuilder.addIfNotBlank(this.paths, value);
        return this.self();
    }

    @Nonnull
    public GitResetBuilder paths(Iterable<String> values) {
        DefaultGitResetBuilder.addIfNotBlank(this.paths, values);
        return this.self();
    }

    @Nonnull
    public GitResetBuilder paths(String value, String ... values) {
        DefaultGitResetBuilder.addIfNotBlank(this.paths, value, values);
        return this.self();
    }

    @Nonnull
    public GitResetBuilder quiet(boolean value) {
        this.quiet = value;
        return this.self();
    }

    @Nonnull
    public GitResetBuilder soft() {
        this.mode = GitResetMode.SOFT;
        return this;
    }

    @Override
    protected void applyArguments() {
        if (this.mode != null) {
            this.builder.argument(this.mode.getFlag());
        }
        if (this.quiet) {
            this.builder.argument("--quiet");
        }
        if (StringUtils.isNotBlank((CharSequence)this.commit)) {
            this.builder.commitish(this.commit);
        }
        this.builder.argument("--");
        this.paths.forEach(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).rawArgument(arg_0));
    }

    @Override
    @Nonnull
    protected GitResetBuilder self() {
        return this;
    }
}

