/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.revlist;

import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.git.command.revlist.GitRevCoreBuilder;
import com.atlassian.bitbucket.scm.git.command.revlist.GitRevListMerges;
import com.atlassian.bitbucket.scm.git.command.revlist.GitRevListOrder;
import com.atlassian.bitbucket.scm.git.command.revlist.GitRevListWalk;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractGitRevCoreBuilder<B extends GitRevCoreBuilder<B>>
extends AbstractGitCommandBuilder<B>
implements GitRevCoreBuilder<B> {
    protected final List<String> revs;
    protected boolean all;
    protected boolean boundary;
    protected boolean branches;
    protected boolean ignoreMissing;
    protected int skip;
    protected boolean stdIn;
    protected boolean tags;
    private final Set<String> files = new LinkedHashSet<String>();
    private String format;
    private LeftOrRight leftOrRight = LeftOrRight.DEFAULT;
    private boolean leftRight;
    private int limit;
    private GitRevListOrder order = GitRevListOrder.DEFAULT;
    private GitRevListMerges merges = GitRevListMerges.DEFAULT;
    private boolean parents;
    private Instant since;
    private GitRevListWalk walk;

    protected AbstractGitRevCoreBuilder(GitFreeFormCommandBuilder builder) {
        super(builder);
        this.revs = new ArrayList<String>();
        this.walk = GitRevListWalk.DEFAULT;
    }

    @Nonnull
    public B all(boolean value) {
        this.all = value;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B boundary(boolean value) {
        this.boundary = value;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B branches(boolean value) {
        this.branches = value;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B clearFiles() {
        this.files.clear();
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B clearRevs() {
        this.revs.clear();
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B file(String value) {
        AbstractGitRevCoreBuilder.addIfNotBlank(this.files, value);
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B files(Iterable<String> values) {
        AbstractGitRevCoreBuilder.addIfNotBlank(this.files, values);
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B files(String value, String ... values) {
        AbstractGitRevCoreBuilder.addIfNotBlank(this.files, value, values);
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B format(String value) {
        this.format = value;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B ignoreMissing(boolean value) {
        this.ignoreMissing = value;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B inputHandler(CommandInputHandler inputHandler) {
        if (inputHandler == null) {
            this.stdIn = false;
            this.builder.clearInputHandler();
        } else {
            this.stdIn = true;
            this.builder.inputHandler(inputHandler);
        }
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B leftOnly(boolean value) {
        this.leftOrRight = value ? LeftOrRight.LEFT_ONLY : LeftOrRight.DEFAULT;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B leftRight(boolean value) {
        this.leftRight = value;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B limit(int value) {
        this.limit = value;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B merges(@Nonnull GitRevListMerges value) {
        this.merges = Objects.requireNonNull(value, "merges");
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B order(@Nonnull GitRevListOrder value) {
        this.order = Objects.requireNonNull(value, "order");
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B parents(boolean value) {
        this.parents = value;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B rev(String value) {
        AbstractGitRevCoreBuilder.addIfNotBlank(this.revs, value);
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B revs(Iterable<String> values) {
        AbstractGitRevCoreBuilder.addIfNotBlank(this.revs, values);
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B revs(String value, String ... values) {
        AbstractGitRevCoreBuilder.addIfNotBlank(this.revs, value, values);
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B rightOnly(boolean value) {
        this.leftOrRight = value ? LeftOrRight.RIGHT_ONLY : LeftOrRight.DEFAULT;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B since(Instant value) {
        this.since = value;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B skip(int value) {
        this.skip = value;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B tags(boolean value) {
        this.tags = value;
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Nonnull
    public B walk(@Nonnull GitRevListWalk value) {
        this.walk = Objects.requireNonNull(value, "walk");
        return (B)((GitRevCoreBuilder)this.self());
    }

    @Override
    protected void applyArguments() {
        this.applyFlags();
        this.applyRevs();
        this.applyFiles();
    }

    protected void applyFiles() {
        this.builder.argument("--");
        this.files.forEach(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).rawArgument(arg_0));
    }

    protected void applyFlags() {
        if (this.all) {
            this.builder.argument("--all");
        }
        if (this.boundary) {
            this.builder.argument("--boundary");
        }
        if (this.branches) {
            this.builder.argument("--branches");
        }
        if (StringUtils.isNotBlank((CharSequence)this.format)) {
            this.builder.argument("--format=" + this.format);
        }
        if (this.ignoreMissing) {
            this.builder.argument("--ignore-missing");
        }
        if (this.leftRight) {
            this.builder.argument("--left-right");
        }
        if (this.limit > 0) {
            this.builder.argument("-" + this.limit);
        }
        if (this.leftOrRight.isFlagged()) {
            this.builder.argument(this.leftOrRight.getFlag());
        }
        if (this.order.isFlagged()) {
            this.builder.argument(this.order.getFlag());
        }
        if (this.merges.isFlagged()) {
            this.builder.argument(this.merges.getFlag());
        }
        if (this.parents) {
            this.builder.argument("--parents");
        }
        if (this.since != null) {
            this.builder.argument("--since=" + this.since.getEpochSecond());
        }
        if (this.skip > 0) {
            this.builder.argument("--skip=" + this.skip);
        }
        if (this.stdIn) {
            this.builder.argument("--stdin");
        }
        if (this.tags) {
            this.builder.argument("--tags");
        }
        if (this.walk.isFlagged()) {
            this.builder.argument(this.walk.getFlag());
        }
    }

    protected abstract void applyRevs();

    private static enum LeftOrRight {
        DEFAULT,
        LEFT_ONLY("--left-only"),
        RIGHT_ONLY("--right-only");

        private final String flag;

        private LeftOrRight() {
            this.flag = null;
        }

        private LeftOrRight(String flag) {
            this.flag = flag;
        }

        public String getFlag() {
            return this.flag;
        }

        public boolean isFlagged() {
            return this.flag != null;
        }
    }
}

