/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.rm;

import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.rm.GitRmBuilder;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultGitRmBuilder
extends AbstractGitCommandBuilder<GitRmBuilder>
implements GitRmBuilder {
    private final GitScmConfig config;
    private final Set<String> paths;
    private boolean force;
    private boolean quiet;
    private boolean recursive;
    private boolean sparse;

    public DefaultGitRmBuilder(GitFreeFormCommandBuilder builder, GitScmConfig config) {
        super((GitFreeFormCommandBuilder)builder.command("rm"));
        this.config = config;
        this.paths = new LinkedHashSet<String>();
        this.sparse = true;
    }

    @Nonnull
    public GitCommand<Void> build() {
        return this.buildWithLoggingHandler();
    }

    @Nonnull
    public GitRmBuilder force(boolean value) {
        this.force = value;
        return this.self();
    }

    @Nonnull
    public GitRmBuilder path(String value) {
        DefaultGitRmBuilder.addIfNotBlank(this.paths, value);
        return this.self();
    }

    @Nonnull
    public GitRmBuilder paths(Iterable<String> values) {
        DefaultGitRmBuilder.addIfNotBlank(this.paths, values);
        return this.self();
    }

    @Nonnull
    public GitRmBuilder paths(String value, String ... values) {
        DefaultGitRmBuilder.addIfNotBlank(this.paths, value, values);
        return this.self();
    }

    @Nonnull
    public GitRmBuilder quiet(boolean value) {
        this.quiet = value;
        return this.self();
    }

    @Nonnull
    public GitRmBuilder recursive(boolean value) {
        this.recursive = value;
        return this.self();
    }

    @Nonnull
    public GitRmBuilder sparse(boolean value) {
        this.sparse = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.force) {
            this.builder.argument("-f");
        }
        if (this.quiet) {
            this.builder.argument("--quiet");
        }
        if (this.recursive) {
            this.builder.argument("-r");
        }
        if (this.sparse) {
            this.builder.argument("--sparse");
        }
        this.builder.argument("--");
        this.paths.forEach(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).rawArgument(arg_0));
    }

    @Override
    @Nonnull
    protected GitRmBuilder self() {
        return this;
    }
}

