/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.status;

import com.atlassian.bitbucket.scm.git.command.status.GitStatusBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitStatusBuilder
extends AbstractGitCommandBuilder<GitStatusBuilder>
implements GitStatusBuilder {
    private final Set<String> paths = new LinkedHashSet<String>();
    private boolean porcelain;
    private boolean shorten;
    private String untracked;

    public DefaultGitStatusBuilder(GitFreeFormCommandBuilder builder) {
        super((GitFreeFormCommandBuilder)builder.command("status"));
    }

    @Nonnull
    public GitStatusBuilder path(String value) {
        DefaultGitStatusBuilder.addIfNotBlank(this.paths, value);
        return this.self();
    }

    @Nonnull
    public GitStatusBuilder paths(Iterable<String> values) {
        DefaultGitStatusBuilder.addIfNotBlank(this.paths, values);
        return this.self();
    }

    @Nonnull
    public GitStatusBuilder paths(String value, String ... values) {
        DefaultGitStatusBuilder.addIfNotBlank(this.paths, value, values);
        return this.self();
    }

    @Nonnull
    public GitStatusBuilder porcelain(boolean value) {
        this.porcelain = value;
        return this.self();
    }

    @Nonnull
    public GitStatusBuilder shorten(boolean value) {
        this.shorten = value;
        return this.self();
    }

    @Nonnull
    public GitStatusBuilder untracked(String value) {
        Preconditions.checkArgument(("no".equals(value) || "normal".equals(value) || "all".equals(value) ? 1 : 0) != 0);
        this.untracked = value;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (this.porcelain) {
            this.builder.argument("--porcelain");
        }
        if (this.shorten) {
            this.builder.argument("--short");
        }
        if (StringUtils.isNotBlank((CharSequence)this.untracked)) {
            this.builder.argument("-u" + this.untracked);
        }
        this.builder.argument("--");
        this.paths.forEach(arg_0 -> ((GitFreeFormCommandBuilder)this.builder).rawArgument(arg_0));
    }

    @Override
    @Nonnull
    protected GitStatusBuilder self() {
        return this;
    }
}

