/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.tag;

import com.atlassian.bitbucket.NoSuchObjectException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.ConflictingRefNameException;
import com.atlassian.bitbucket.repository.DuplicateRefException;
import com.atlassian.bitbucket.repository.InvalidRefNameException;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import com.atlassian.stash.internal.scm.git.command.branch.CreateBranchCommandExitHandler;
import jakarta.annotation.Nonnull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateTagCommandExitHandler
extends GitCommandExitHandler {
    private static final Pattern PATTERN_INVALID_START_POINT = Pattern.compile("fatal: Failed to resolve '(.*)' as a valid ref.$", 8);
    private static final Pattern PATTERN_INVALID_TAG_NAME = Pattern.compile("fatal: '(.*)' is not a valid tag name.$", 8);
    private static final Pattern PATTERN_TAG_ALREADY_EXISTS = Pattern.compile("fatal: tag '(.*)' already exists$", 8);

    public CreateTagCommandExitHandler(@Nonnull I18nService i18nService, @Nonnull Repository repository) {
        super(i18nService, repository);
    }

    protected void evaluateStdErr(String stdErr, String command) {
        Matcher matcher = PATTERN_INVALID_START_POINT.matcher(stdErr);
        if (matcher.find()) {
            String startPoint = matcher.group(1);
            throw new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.service.repository.tag.startpointinvalid", new Object[]{startPoint}), startPoint);
        }
        matcher = PATTERN_INVALID_TAG_NAME.matcher(stdErr);
        if (matcher.find()) {
            String name = matcher.group(1);
            throw new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.service.repository.tag.nameinvalid", new Object[]{name}), name);
        }
        matcher = PATTERN_TAG_ALREADY_EXISTS.matcher(stdErr);
        if (matcher.find()) {
            String name = matcher.group(1);
            throw new DuplicateRefException(this.i18nService.createKeyedMessage("bitbucket.service.repository.tag.duplicate", new Object[]{name, this.repository.getName()}), name);
        }
        matcher = CreateBranchCommandExitHandler.PATTERN_REF_FILE_DIR_CONFLICT.matcher(stdErr);
        if (matcher.find()) {
            throw this.newConflictingTagName(CreateTagCommandExitHandler.toMinimalRef(matcher.group(1)));
        }
        matcher = CreateBranchCommandExitHandler.PATTERN_REF_DIR_FILE_CONFLICT.matcher(stdErr);
        if (matcher.find()) {
            throw this.newConflictingTagName(CreateTagCommandExitHandler.toMinimalRef(matcher.group(1)));
        }
        matcher = CreateBranchCommandExitHandler.PATTERN_PACKED_REF_CONFLICT.matcher(stdErr);
        if (matcher.find()) {
            throw this.newConflictingTagName(CreateTagCommandExitHandler.toMinimalRef(matcher.group(2)), CreateTagCommandExitHandler.toMinimalRef(matcher.group(1)));
        }
        super.evaluateStdErr(stdErr, command);
    }

    private ConflictingRefNameException newConflictingTagName(MinimalRef newTag) {
        throw new ConflictingRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.tag.create.looserefconflict", new Object[]{newTag.getDisplayId()}), newTag);
    }

    private ConflictingRefNameException newConflictingTagName(MinimalRef newTag, MinimalRef existingTag) {
        throw new ConflictingRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.tag.create.packedrefconflict", new Object[]{newTag.getDisplayId(), existingTag.getDisplayId()}), newTag);
    }

    private static MinimalRef toMinimalRef(String id) {
        return ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().displayId(GitRefPattern.TAGS.unqualify(id))).id(id)).type((RefType)StandardRefType.TAG).build();
    }
}

