/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.tag;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.tag.GitTagCreateBuilder;
import com.atlassian.bitbucket.scm.git.command.tag.GitTagType;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.tag.CreateTagCommandExitHandler;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitTagCreateBuilder
extends AbstractGitCommandBuilder<GitTagCreateBuilder>
implements GitTagCreateBuilder {
    private final I18nService i18nService;
    private final String name;
    private final Repository repository;
    private boolean force;
    private String message;
    private String startPoint;
    private GitTagType type;
    private boolean useDefaultExitHandler;

    public DefaultGitTagCreateBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, String name, Repository repository) {
        super(builder);
        this.i18nService = i18nService;
        this.name = this.checkNotBlank(name, "name");
        this.repository = repository;
        this.type = GitTagType.ANNOTATED;
        this.useDefaultExitHandler = true;
    }

    @Nonnull
    public Command<Void> build() {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new CreateTagCommandExitHandler(this.i18nService, this.repository));
        }
        return this.buildWithLoggingHandler();
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new CreateTagCommandExitHandler(this.i18nService, this.repository));
        }
        return super.build(outputHandler);
    }

    @Override
    @Nonnull
    public GitTagCreateBuilder defaultExitHandler() {
        this.useDefaultExitHandler = true;
        return this.self();
    }

    @Override
    @Nonnull
    public GitTagCreateBuilder exitHandler(@Nonnull CommandExitHandler value) {
        super.exitHandler(value);
        this.useDefaultExitHandler = false;
        return this.self();
    }

    @Nonnull
    public GitTagCreateBuilder force(boolean value) {
        this.force = value;
        return this.self();
    }

    @Nonnull
    public GitTagCreateBuilder message(String value) {
        this.message = value;
        return this.self();
    }

    @Nonnull
    public GitTagCreateBuilder startPoint(String value) {
        this.startPoint = value;
        return this.self();
    }

    @Nonnull
    public GitTagCreateBuilder type(@Nonnull GitTagType value) {
        this.type = Objects.requireNonNull(value, "type");
        return this.self();
    }

    @Override
    protected void applyArguments() {
        if (GitTagType.ANNOTATED.equals((Object)this.type)) {
            this.builder.argument("-a");
            this.builder.argument("-m");
            if (StringUtils.isBlank((CharSequence)this.message)) {
                this.builder.argument(this.i18nService.getMessage("bitbucket.git.tag.defaultmessage", new Object[]{this.startPoint}));
            } else {
                this.builder.argument(this.message);
            }
        }
        if (this.force) {
            this.builder.argument("-f");
        }
        this.builder.argument("--");
        this.builder.argument(this.name);
        if (StringUtils.isNotBlank((CharSequence)this.startPoint)) {
            this.builder.argument(this.startPoint);
        }
    }

    @Override
    @Nonnull
    protected GitTagCreateBuilder self() {
        return this;
    }
}

