/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.tag;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.tag.GitTagDeleteBuilder;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.tag.DeleteTagCommandExitHandler;
import jakarta.annotation.Nonnull;

public class DefaultGitTagDeleteBuilder
extends AbstractGitCommandBuilder<GitTagDeleteBuilder>
implements GitTagDeleteBuilder {
    private final I18nService i18nService;
    private final String name;
    private final Repository repository;
    private boolean useDefaultExitHandler;

    public DefaultGitTagDeleteBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, String name, Repository repository) {
        super(builder);
        this.i18nService = i18nService;
        this.name = this.checkNotBlank(name, "name");
        this.repository = repository;
        this.useDefaultExitHandler = true;
    }

    @Nonnull
    public GitCommand<Void> build() {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new DeleteTagCommandExitHandler(this.i18nService, this.repository));
        }
        return this.buildWithLoggingHandler();
    }

    @Override
    @Nonnull
    public GitTagDeleteBuilder defaultExitHandler() {
        this.useDefaultExitHandler = true;
        return this.self();
    }

    @Override
    @Nonnull
    public GitTagDeleteBuilder exitHandler(@Nonnull CommandExitHandler value) {
        super.exitHandler(value);
        this.useDefaultExitHandler = false;
        return this.self();
    }

    @Override
    protected void applyArguments() {
        this.builder.argument("-d");
        this.builder.argument(this.name);
    }

    @Override
    @Nonnull
    protected GitTagDeleteBuilder self() {
        return this;
    }
}

