/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.tag;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.NoSuchTagException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import jakarta.annotation.Nonnull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeleteTagCommandExitHandler
extends GitCommandExitHandler {
    private static final Pattern PATTERN_TAG_NOT_FOUND = Pattern.compile("error: tag '(.+)' not found\\.$", 8);

    public DeleteTagCommandExitHandler(@Nonnull I18nService i18nService, @Nonnull Repository repository) {
        super(i18nService, repository);
    }

    protected void evaluateStdErr(String stdErr, String command) {
        Matcher matcher = PATTERN_TAG_NOT_FOUND.matcher(stdErr);
        if (matcher.find()) {
            String name = matcher.group(1);
            throw new NoSuchTagException(this.i18nService.createKeyedMessage("bitbucket.service.repository.tag.notfound", new Object[]{name, this.repository.getName()}), name);
        }
        super.evaluateStdErr(stdErr, command);
    }
}

