/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.updateref;

import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRefBuilderSupport;
import com.atlassian.stash.internal.scm.git.command.AbstractGitCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractGitUpdateRefBuilder<B extends GitUpdateRefBuilderSupport<B>>
extends AbstractGitCommandBuilder<B>
implements GitUpdateRefBuilderSupport<B> {
    private final String ref;
    private boolean deref;
    private String message;
    private String oldValue;

    public AbstractGitUpdateRefBuilder(GitFreeFormCommandBuilder builder, String ref) {
        super(builder);
        this.ref = this.checkNotBlank(ref, "ref");
        this.deref = true;
    }

    @Nonnull
    public GitCommand<Void> build() {
        return this.buildWithLoggingHandler();
    }

    @Nonnull
    public B deref(boolean value) {
        this.deref = value;
        return (B)((GitUpdateRefBuilderSupport)this.self());
    }

    @Nonnull
    public B message(String value) {
        this.message = value;
        return (B)((GitUpdateRefBuilderSupport)this.self());
    }

    @Nonnull
    public B oldValue(String value) {
        this.oldValue = value;
        return (B)((GitUpdateRefBuilderSupport)this.self());
    }

    @Override
    protected void applyArguments() {
        if (StringUtils.isNotBlank((CharSequence)this.message)) {
            ((GitFreeFormCommandBuilder)this.builder.argument("-m")).argument(this.message);
        }
        if (!this.deref) {
            this.builder.argument("--no-deref");
        }
        this.applyRefArguments(this.ref);
        if (StringUtils.isNotBlank((CharSequence)this.oldValue)) {
            this.builder.commitish(this.oldValue);
        }
    }

    protected abstract void applyRefArguments(String var1);
}

