/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.updateref;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRefDeleteBuilder;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.updateref.AbstractGitUpdateRefBuilder;
import com.atlassian.stash.internal.scm.git.command.updateref.DeleteUpdateRefCommandExitHandler;
import jakarta.annotation.Nonnull;

public class DefaultGitUpdateRefDeleteBuilder
extends AbstractGitUpdateRefBuilder<GitUpdateRefDeleteBuilder>
implements GitUpdateRefDeleteBuilder {
    private final I18nService i18nService;
    private final Repository repository;
    private boolean useDefaultExitHandler;

    public DefaultGitUpdateRefDeleteBuilder(GitFreeFormCommandBuilder builder, I18nService i18nService, Repository repository, String ref) {
        super(builder, ref);
        this.i18nService = i18nService;
        this.repository = repository;
        this.useDefaultExitHandler = true;
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        if (this.useDefaultExitHandler) {
            this.builder.exitHandler((CommandExitHandler)new DeleteUpdateRefCommandExitHandler(this.i18nService, this.repository));
        }
        return super.build(outputHandler);
    }

    @Override
    @Nonnull
    public GitUpdateRefDeleteBuilder defaultExitHandler() {
        this.useDefaultExitHandler = true;
        return this.self();
    }

    @Override
    @Nonnull
    public GitUpdateRefDeleteBuilder exitHandler(@Nonnull CommandExitHandler value) {
        super.exitHandler(value);
        this.useDefaultExitHandler = false;
        return this.self();
    }

    @Override
    protected void applyRefArguments(String ref) {
        ((GitFreeFormCommandBuilder)this.builder.argument("-d")).argument(ref);
    }

    @Override
    @Nonnull
    protected GitUpdateRefDeleteBuilder self() {
        return this;
    }
}

