/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.updateref;

import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteUpdateRefCommandExitHandler
extends GitCommandExitHandler {
    static final Pattern PATTERN_UNABLE_TO_RESOLVE = Pattern.compile("error: (?:cannot lock ref '([^']+)': )?unable to resolve reference '?([^':]+)'?:?.*$", 10);
    private static final Logger log = LoggerFactory.getLogger(DeleteUpdateRefCommandExitHandler.class);

    public DeleteUpdateRefCommandExitHandler(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService, repository);
    }

    protected void evaluateStdErr(String stdErr, String command) {
        Matcher matcher = PATTERN_UNABLE_TO_RESOLVE.matcher(stdErr);
        if (matcher.find()) {
            String refId = matcher.group(1);
            if (refId == null) {
                refId = matcher.group(2);
            } else if (!refId.equals(matcher.group(2))) {
                log.warn("[{}] != [{}]: Unexpected mismatch in ref names after parsing\n{}", new Object[]{refId, matcher.group(2), stdErr});
            }
            throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.repository.deleteref.nosuchref", new Object[]{refId}), refId);
        }
        super.evaluateStdErr(stdErr, command);
    }
}

