/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.gc;

import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetGarbageCollectionPausedRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.scm.git.gc.GcPause;
import com.atlassian.stash.internal.scm.git.gc.GitGarbageTruck;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import jakarta.annotation.Nonnull;
import java.nio.channels.OverlappingFileLockException;
import java.time.Duration;

public class MeshGitGarbageTruck
implements GitGarbageTruck {
    private final RpcRepositoryClient repositoryClient;

    public MeshGitGarbageTruck(RpcRepositoryClient repositoryClient) {
        this.repositoryClient = repositoryClient;
    }

    @Override
    public GcPause tryPauseGc(@Nonnull Repository repository, @Nonnull Duration timeout) throws OverlappingFileLockException {
        if (this.repositoryClient.setGarbageCollectionPaused(repository, RpcSetGarbageCollectionPausedRequest.newBuilder().setTimeout(timeout.getSeconds()).setPaused(true))) {
            return () -> this.repositoryClient.setGarbageCollectionPaused(repository, RpcSetGarbageCollectionPausedRequest.newBuilder().setPaused(false));
        }
        return null;
    }
}

