/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.home;

import com.atlassian.bitbucket.home.AbstractHomeUpdateHandler;
import com.atlassian.bitbucket.home.HomeUpdate;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.git.GitException;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.HomeLayout;
import jakarta.annotation.Nonnull;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitAlternatesHomeUpdateHandler
extends AbstractHomeUpdateHandler {
    public static final Pattern PATTERN_PATH = Pattern.compile(".+[/\\\\]data[/\\\\]repositories[/\\\\](\\d+)[/\\\\]objects");
    private static final Logger log = LoggerFactory.getLogger(GitAlternatesHomeUpdateHandler.class);
    private final HomeLayout homeLayout;
    private final I18nService i18nService;
    private final List<Path> updated;

    public GitAlternatesHomeUpdateHandler(HomeLayout homeLayout, I18nService i18nService) {
        this.homeLayout = homeLayout;
        this.i18nService = i18nService;
        this.updated = new ArrayList<Path>();
    }

    public void apply(@Nonnull HomeUpdate update) {
        Path[] forkDirs = this.listForks();
        if (forkDirs == null || forkDirs.length == 0) {
            log.debug("No forks exist; no alternates need to be updated after home directory move");
        } else {
            log.warn("Updating alternates for {} fork(s) after home directory move", (Object)forkDirs.length);
            try {
                this.updateForks(forkDirs, update.getOldDir(), update.getNewDir(), Mode.UPDATE);
            }
            catch (GitException e) {
                this.rollback(update);
                throw e;
            }
        }
    }

    public void rollback(@Nonnull HomeUpdate update) {
        if (this.updated.isEmpty()) {
            log.debug("No alternates were updated; no rollback is necessary");
        } else {
            log.warn("Attempting to revert alternates for {} fork(s) after failed update", (Object)this.updated.size());
            try {
                Path[] forkDirs = this.updated.toArray(new Path[0]);
                this.updateForks(forkDirs, update.getNewDir(), update.getOldDir(), Mode.REVERT);
            }
            catch (GitException e) {
                log.error("Previously updated alternates could not be reverted", (Throwable)e);
            }
        }
    }

    private static boolean isAlternateInPath(String alternate, String path) {
        int length = path.length();
        if (alternate.length() >= length + 20 && alternate.startsWith(path)) {
            char next = alternate.charAt(length);
            return next == '/' || next == '\\';
        }
        return false;
    }

    private Path[] listForks() {
        Path[] pathArray;
        block8: {
            Path repositoriesDir = this.homeLayout.getRepositoriesDir();
            Stream<Path> paths = Files.list(repositoriesDir);
            try {
                pathArray = (Path[])paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(dir -> Files.isRegularFile(MoreFiles.resolve((Path)dir, (String)"objects", (String[])new String[]{"info", "alternates"}), new LinkOption[0])).toArray(Path[]::new);
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GitException(this.i18nService.createKeyedMessage("bitbucket.git.home.updatefailed", new Object[0]), (Throwable)e);
                }
            }
            paths.close();
        }
        return pathArray;
    }

    private String rewriteAlternate(String filePath, String line, String oldPath, String newPath) {
        if (GitAlternatesHomeUpdateHandler.isAlternateInPath(line, oldPath)) {
            Matcher matcher = PATTERN_PATH.matcher(line);
            if (matcher.matches()) {
                String original = line;
                Object[] components = new String[]{newPath, "data", "repositories", matcher.group(1), "objects"};
                line = StringUtils.join((Object[])components, (String)File.separator);
                log.debug("Rewrote alternate from [{}] to [{}] in {}", new Object[]{original, line, filePath});
            } else {
                log.warn("In {}, \"{}\" looks like it references the old home location ({}), but it does not match the expected pattern for an alternate. It will not be updated", new Object[]{filePath, line, oldPath});
            }
        } else {
            log.warn("In {}, \"{}\" appears to be an alternate to a location outside the home directory. Such alternates are not created or managed by the system and will not be updated", (Object)filePath, (Object)line);
        }
        return line;
    }

    private void updateAlternates(Path alternates, String oldPath, String newPath) throws IOException {
        List<String> lines = Files.readAllLines(alternates, StandardCharsets.UTF_8);
        try (BufferedWriter writer = Files.newBufferedWriter(alternates, StandardCharsets.UTF_8, new OpenOption[0]);){
            String filePath = alternates.toAbsolutePath().toString();
            for (String line : lines) {
                writer.write(this.rewriteAlternate(filePath, line, oldPath, newPath));
                ((Writer)writer).write(10);
            }
        }
    }

    private void updateForks(Path[] forkDirs, String oldPath, String newPath, Mode mode) {
        int failed = 0;
        for (Path forkDir : forkDirs) {
            Path alternates = MoreFiles.resolve((Path)forkDir, (String)"objects", (String[])new String[]{"info", "alternates"});
            if (!Files.isRegularFile(alternates, new LinkOption[0])) continue;
            try {
                this.updateAlternates(alternates, oldPath, newPath);
                log.info("Successfully {} alternates in {}", (Object)mode.getDone(), (Object)forkDir.toAbsolutePath());
                this.updated.add(forkDir);
            }
            catch (IOException e) {
                log.error("Failed to {} alternates in {}", new Object[]{mode.getDoing(), forkDir.toAbsolutePath(), e});
                if (mode.isFailFast()) {
                    throw new GitException(this.i18nService.createKeyedMessage("bitbucket.git.home.updatefailed", new Object[0]));
                }
                ++failed;
            }
        }
        if (failed > 0) {
            throw new GitException(this.i18nService.createKeyedMessage("bitbucket.git.home.revertfailed", new Object[]{failed, forkDirs.length}));
        }
        log.info("Successfully {} alternates for {} forks", (Object)mode.getDone(), (Object)forkDirs.length);
    }

    private static enum Mode {
        REVERT("revert", "reverted", false),
        UPDATE("update", "updated", true);

        private final String doing;
        private final String done;
        private final boolean failFast;

        private Mode(String doing, String done, boolean failFast) {
            this.doing = doing;
            this.done = done;
            this.failFast = failFast;
        }

        public String getDoing() {
            return this.doing;
        }

        public String getDone() {
            return this.done;
        }

        public boolean isFailFast() {
            return this.failFast;
        }
    }
}

