/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.io;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;

public class CopyLooseObjectsVisitor
extends SimpleFileVisitor<Path> {
    private static final Pattern PATTERN_OBJECT_DIR = Pattern.compile("[a-f0-9]{2}");
    private static final Pattern PATTERN_OBJECT_FILE = Pattern.compile("[a-f0-9]{38}");
    private final Path objectsDir;
    private boolean tryMove;

    public CopyLooseObjectsVisitor(Path repositoryDir, boolean tryMove) {
        this.tryMove = tryMove;
        this.objectsDir = repositoryDir.resolve("objects");
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        String dirName = dir.getFileName().toString();
        return "objects".equals(dirName) || PATTERN_OBJECT_DIR.matcher(dirName).matches() ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path objectDir;
        Path objectFile;
        Path fileName = file.getFileName();
        if (PATTERN_OBJECT_FILE.matcher(fileName.toString()).matches() && !Files.exists(objectFile = (objectDir = this.objectsDir.resolve(file.getParent().getFileName())).resolve(fileName), new LinkOption[0])) {
            Files.createDirectories(objectDir, new FileAttribute[0]);
            if (!this.tryMove || !this.moveObject(file, objectFile)) {
                this.copyObject(file, objectFile);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyObject(Path srcObject, Path dstObject) throws IOException {
        Path tmpObject = Files.createTempFile(dstObject.getParent(), "atl-", null, new FileAttribute[0]);
        try {
            Files.copy(srcObject, tmpObject, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            try {
                Files.move(tmpObject, dstObject, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AccessDeniedException e) {
                this.onAccessDenied(dstObject, e);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        finally {
            Files.deleteIfExists(tmpObject);
        }
    }

    private boolean moveObject(Path srcObject, Path dstObject) throws AccessDeniedException {
        try {
            Files.move(srcObject, dstObject, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AccessDeniedException e) {
            this.onAccessDenied(dstObject, e);
        }
        catch (FileAlreadyExistsException e) {
        }
        catch (IOException e) {
            this.tryMove = !(e instanceof AtomicMoveNotSupportedException);
            return false;
        }
        return true;
    }

    private void onAccessDenied(Path dstObject, AccessDeniedException e) throws AccessDeniedException {
        if (!Files.exists(dstObject, new LinkOption[0])) {
            throw e;
        }
    }
}

