/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.repository.RemoteRepositoryId;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshRepositoryArgumentCodec;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class DefaultMeshRepositoryArgumentCodec
implements MeshRepositoryArgumentCodec {
    private static final Pattern PATTERN_REPOSITORY = Pattern.compile("\\$repository_path\\('(.+)'\\)");
    private final GitScmConfig config;
    private final RepositorySupplier repositorySupplier;
    private final GitRequestHelper requestHelper;
    private final EscalatedSecurityContext withRepoRead;

    public DefaultMeshRepositoryArgumentCodec(GitScmConfig config, RepositorySupplier repositorySupplier, GitRequestHelper requestHelper, SecurityService securityService) {
        this.config = config;
        this.repositorySupplier = repositorySupplier;
        this.requestHelper = requestHelper;
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, "MeshRepositoryArgumentCodec");
    }

    @Override
    @Nonnull
    public Set<Repository> decodeRemoteRepositories(@Nonnull Collection<String> arguments) {
        return (Set)Objects.requireNonNull(arguments, "arguments").stream().filter(argument -> PATTERN_REPOSITORY.matcher((CharSequence)argument).matches()).map(RemoteRepositoryId::parse).filter(Objects::nonNull).distinct().map(repositoryId -> this.repositorySupplier.getById(repositoryId.getLocalId())).filter(Objects::nonNull).collect(MoreCollectors.toImmutableSet());
    }

    @Override
    @Nonnull
    public String encode(@Nonnull Path path) {
        Objects.requireNonNull(path, "path");
        return this.getRepositoryForPath(path).map(this::encodeRepository).orElseGet(() -> path.toAbsolutePath().toString());
    }

    @Override
    @Nonnull
    public String encode(@Nonnull Repository repository) {
        return this.encodeRepository(Objects.requireNonNull(repository, "repository"));
    }

    @Override
    @Nonnull
    public String encode(@Nonnull String value) {
        Objects.requireNonNull(value, "value");
        return this.getRepositoryForPath(Paths.get(value, new String[0])).map(this::encodeRepository).orElse(value);
    }

    private String encodeRepository(Repository repository) {
        return "$repository_path('" + this.requestHelper.toRepositoryId(repository) + "')";
    }

    private Optional<Repository> getRepositoryForPath(Path path) {
        String dirName = path.getFileName().toString();
        try {
            int id = Integer.parseInt(dirName);
            Repository repository = (Repository)this.withRepoRead.call(() -> this.repositorySupplier.getById(id));
            if (repository != null && path.toAbsolutePath().equals(this.config.getRepositoryDir(repository))) {
                return Optional.of(repository);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

