/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HierarchyReplicaRepairs {
    private static final Logger log = LoggerFactory.getLogger(HierarchyReplicaRepairs.class);
    private final AtomicBoolean canceled;
    private final RpcManagementClient managementClient;
    private final int maxConcurrency;
    private final Map<Repository, ReplicaRepairs> repairsByRepository;
    private final Semaphore semaphore;
    private final MeshNode sourceNode;
    private final Collection<MeshNode> targetNodes;

    HierarchyReplicaRepairs(RpcManagementClient managementClient, int maxConcurrency, MeshNode sourceNode, Collection<MeshNode> targetNodes) {
        this.managementClient = managementClient;
        this.maxConcurrency = Math.max(1, maxConcurrency);
        this.sourceNode = sourceNode;
        this.targetNodes = targetNodes;
        this.canceled = new AtomicBoolean();
        this.repairsByRepository = new HashMap<Repository, ReplicaRepairs>();
        this.semaphore = new Semaphore(maxConcurrency);
    }

    void await() {
        try {
            this.repairsByRepository.values().forEach(ReplicaRepairs::await);
        }
        finally {
            this.cancel();
        }
    }

    void cancel() {
        if (this.canceled.compareAndSet(false, true)) {
            this.repairsByRepository.values().forEach(ReplicaRepairs::cancel);
            this.semaphore.release(0x3FFFFFFF);
        }
    }

    void startReplicaRepairs(@Nonnull Repository repository) {
        ReplicaRepairs originRepairs;
        Preconditions.checkState((!this.repairsByRepository.containsKey(repository) ? 1 : 0) != 0, (String)"Repair of %s replicas has already started", (Object)repository);
        ReplicaRepairs repositoryRepairs = this.repairsByRepository.computeIfAbsent(repository, x$0 -> new ReplicaRepairs((Repository)x$0));
        Repository origin = repository.getOrigin();
        ReplicaRepairs replicaRepairs = originRepairs = origin == null ? null : this.repairsByRepository.get(origin);
        if (originRepairs == null) {
            if (origin != null) {
                log.warn("Repair of {} started before its origin ({}). Has origin been deleted?", (Object)repository, (Object)origin);
            }
            repositoryRepairs.start();
        } else {
            originRepairs.whenComplete(success -> {
                if (success.booleanValue() && !this.canceled.get()) {
                    repositoryRepairs.start();
                } else {
                    repositoryRepairs.cancel();
                }
            });
        }
    }

    private int getConcurrency() {
        return this.maxConcurrency - this.semaphore.availablePermits();
    }

    private class ReplicaRepairs {
        private final List<CompletableFuture<Boolean>> futures;
        private final int quorumSize;
        private final Repository repository;
        private final CompletableFuture<Void> result;
        private final AtomicInteger syncedCount;
        private Throwable throwable;

        ReplicaRepairs(Repository repository) {
            this.repository = repository;
            this.futures = new ArrayList<CompletableFuture<Boolean>>(HierarchyReplicaRepairs.this.targetNodes.size());
            this.quorumSize = (HierarchyReplicaRepairs.this.targetNodes.size() + 1) / 2 + 1;
            this.result = new CompletableFuture();
            this.syncedCount = new AtomicInteger(1);
        }

        void await() {
            try {
                this.result.get();
            }
            catch (CancellationException | ExecutionException exception) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted waiting for " + String.valueOf(this.repository) + " repairs to complete");
            }
            int synced = this.syncedCount.get();
            int replicaCount = HierarchyReplicaRepairs.this.targetNodes.size() + 1;
            if (synced < this.quorumSize) {
                if (this.throwable != null) {
                    Throwables.throwIfUnchecked((Throwable)this.throwable);
                }
                throw new RuntimeException(String.format("[%s] Not enough replicas synced (%d of %d) to reach a quorum. Aborting migration", this.repository, synced, replicaCount), this.throwable);
            }
            if (synced < HierarchyReplicaRepairs.this.targetNodes.size() || this.throwable != null) {
                log.warn("[{}] Not all replicas synced ({} of {}) but a quorum is available. Proceeding with migration", new Object[]{this.repository, synced, replicaCount, this.throwable});
            }
        }

        void cancel() {
            this.futures.forEach(future -> future.cancel(false));
            this.result.complete(null);
        }

        void start() {
            Preconditions.checkState((boolean)this.futures.isEmpty(), (String)"Repair of %s has already started", (Object)this.repository);
            CompletionStage<Object> future = CompletableFuture.completedFuture(null);
            for (MeshNode replicaNode : HierarchyReplicaRepairs.this.targetNodes) {
                try {
                    HierarchyReplicaRepairs.this.semaphore.acquire();
                    if (HierarchyReplicaRepairs.this.canceled.get()) {
                        HierarchyReplicaRepairs.this.semaphore.release();
                        break;
                    }
                    log.debug("[{}] Started repair for replica {} ({} repairs active)", new Object[]{this.repository, replicaNode, HierarchyReplicaRepairs.this.getConcurrency()});
                    long start = System.currentTimeMillis();
                    CompletableFuture<Boolean> replicaFuture = this.startRepair(replicaNode);
                    this.futures.add(replicaFuture);
                    future = future.thenCombine(((CompletableFuture)replicaFuture.exceptionally(this::onError)).thenApply(synced -> {
                        HierarchyReplicaRepairs.this.semaphore.release();
                        log.debug("[{}] Finished {} repair for replica {} in {}ms ({} repairs active)", new Object[]{this.repository, synced != false ? "successful" : "failed", replicaNode, System.currentTimeMillis() - start, HierarchyReplicaRepairs.this.getConcurrency()});
                        if (synced.booleanValue()) {
                            this.syncedCount.incrementAndGet();
                        }
                        return synced;
                    }), (ignored1, ignored2) -> null);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            future.handle((success, throwable) -> this.result.complete(null));
        }

        void whenComplete(Consumer<? super Boolean> callback) {
            this.result.whenComplete((ignored, throwable) -> callback.accept(this.isSuccess()));
        }

        private boolean isSuccess() {
            return this.syncedCount.get() >= this.quorumSize;
        }

        private synchronized Boolean onError(Throwable exception) {
            if (this.throwable == null) {
                this.throwable = exception;
            } else {
                this.throwable.addSuppressed(exception);
            }
            return Boolean.FALSE;
        }

        private CompletableFuture<Boolean> startRepair(MeshNode targetNode) {
            try {
                return HierarchyReplicaRepairs.this.managementClient.repairRepository(HierarchyReplicaRepairs.this.sourceNode, targetNode, this.repository);
            }
            catch (RuntimeException e) {
                CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
                future.completeExceptionally(e);
                return future;
            }
        }
    }
}

