/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandAware;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.bitbucket.scm.Watchdog;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class LatchedNioStdioHandler<T>
implements CommandAware,
NioStdioHandler<T>,
CommandSummaryHandler {
    private final NioStdioHandler<T> delegate;
    private final CountDownLatch latch;

    public LatchedNioStdioHandler(NioStdioHandler<T> delegate) {
        this.delegate = delegate;
        this.latch = new CountDownLatch(1);
    }

    public void awaitStart() {
        try {
            if (!this.latch.await(10L, TimeUnit.SECONDS)) {
                LoggerFactory.getLogger(LatchedNioStdioHandler.class).warn("Timed out waiting for onStarted to be called (delegate is {})", (Object)this.delegate.getClass().getName());
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    public void complete() throws IOException {
        this.delegate.complete();
    }

    public T getOutput() {
        return (T)this.delegate.getOutput();
    }

    public void onComplete(@Nonnull CommandSummary summary) throws IOException {
        if (this.delegate instanceof CommandSummaryHandler) {
            ((CommandSummaryHandler)this.delegate).onComplete(summary);
        }
    }

    public void onExit(int exitCode) {
        try {
            this.delegate.onExit(exitCode);
        }
        finally {
            this.latch.countDown();
        }
    }

    public void onPreStart(@Nonnull NioProcess process) {
        this.delegate.onPreStart(process);
    }

    public void onStart(@Nonnull NioProcess process) {
        try {
            this.delegate.onStart(process);
        }
        finally {
            this.latch.countDown();
        }
    }

    public boolean onStdinReady(@Nonnull ByteBuffer buffer) {
        return this.delegate.onStdinReady(buffer);
    }

    public void onStderr(@Nonnull ByteBuffer buffer, boolean closed) {
        this.delegate.onStderr(buffer, closed);
    }

    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        this.delegate.onStdout(buffer, closed);
    }

    public void process(@Nonnull InputStream output) throws IOException {
        this.delegate.process(output);
    }

    public void setCommand(@Nonnull Command<?> command) {
        if (this.delegate instanceof CommandAware) {
            ((CommandAware)this.delegate).setCommand(command);
        }
    }

    public void setWatchdog(@Nonnull Watchdog watchdog) {
        this.delegate.setWatchdog(watchdog);
    }
}

