/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBatchChangesRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCatFileBatchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitTimeouts;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.bulk.BulkChangeType;
import com.atlassian.bitbucket.scm.bulk.BulkContentCallback;
import com.atlassian.bitbucket.scm.bulk.BulkContentCommandParameters;
import com.atlassian.bitbucket.scm.bulk.BulkContentContext;
import com.atlassian.bitbucket.scm.bulk.BulkContentDisposition;
import com.atlassian.bitbucket.scm.bulk.BulkContentSummary;
import com.atlassian.bitbucket.scm.bulk.BulkFile;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.bulk.BatchChangeCallback;
import com.atlassian.stash.internal.scm.git.bulk.FileChangeWithSize;
import com.atlassian.stash.internal.scm.git.bulk.FileReadingBatchCatFileStdioHandler;
import com.atlassian.stash.internal.scm.git.command.SimpleGitCommand;
import com.atlassian.stash.internal.scm.git.io.NullTerminatedWriter;
import com.atlassian.stash.internal.scm.git.mesh.RpcBatchClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcPlumbingClient;
import com.google.protobuf.ByteString;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshBulkContentCommand
extends SimpleGitCommand<Void> {
    private static final Logger log = LoggerFactory.getLogger(MeshBulkContentCommand.class);
    private final RpcBatchClient batchClient;
    private final BulkContentCallback callback;
    private final GitScmConfig config;
    private final BulkContentCommandParameters parameters;
    private final RpcPlumbingClient plumbingClient;
    private final Repository repository;
    private boolean hasFilesToProcess;

    public MeshBulkContentCommand(@Nonnull RpcBatchClient batchClient, @Nonnull GitScmConfig config, @Nonnull ExecutorService executorService, @Nonnull RpcPlumbingClient plumbingClient, @Nonnull Repository repository, @Nonnull BulkContentCallback callback, @Nonnull BulkContentCommandParameters parameters) {
        super(executorService);
        this.batchClient = batchClient;
        this.callback = callback;
        this.config = config;
        this.parameters = parameters;
        this.plumbingClient = plumbingClient;
        this.repository = repository;
    }

    public Void call() {
        BulkContentContext.Builder builder = new BulkContentContext.Builder(this.parameters.getUntilCommitId());
        this.parameters.getSinceCommitId().ifPresent(arg_0 -> ((BulkContentContext.Builder)builder).sinceCommitId(arg_0));
        this.callback.onStart(builder.build());
        CommandResult result = this.bulkContent();
        this.callback.onEnd(new BulkContentSummary.Builder(result).build());
        return null;
    }

    private void applyTimeouts(Consumer<RpcGitTimeouts> consumer) {
        this.executionTimeout.ifPresent(execution -> {
            RpcGitTimeouts timeouts = RpcGitTimeouts.newBuilder().setExecution(execution).setIdle(this.idleTimeout.orElse(60L)).buildPartial();
            consumer.accept(timeouts);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult bulkContent() {
        Path fileChangesOutput = null;
        try {
            fileChangesOutput = this.createTempFile();
            CommandResult fileChangesResult = this.fileChanges(fileChangesOutput);
            if (fileChangesResult != CommandResult.SUCCEEDED) {
                CommandResult commandResult = fileChangesResult;
                return commandResult;
            }
            if (!this.hasFilesToProcess) {
                CommandResult commandResult = CommandResult.SUCCEEDED;
                return commandResult;
            }
            CommandResult commandResult = this.streamToCallback(this.repository, fileChangesOutput);
            return commandResult;
        }
        catch (IOException e) {
            log.error("Failed creating temporary files for bulk content command", (Throwable)e);
            CommandResult commandResult = CommandResult.FAILED;
            return commandResult;
        }
        finally {
            if (fileChangesOutput != null) {
                MoreFiles.deleteQuietly((Path)fileChangesOutput);
            }
        }
    }

    private Path createTempFile() throws IOException {
        Path tempDir = this.config.getTempDir();
        String prefix = this.repository.getSlug() + "-bulk-content-file-change-with-size";
        return Files.createTempFile(tempDir, prefix, null, new FileAttribute[0]);
    }

    private CommandResult fileChanges(Path metadataOutput) {
        try (BufferedWriter writer = Files.newBufferedWriter(metadataOutput, StandardOpenOption.TRUNCATE_EXISTING);){
            RpcBatchChangesRequest.Builder builder = RpcBatchChangesRequest.newBuilder().setSinceCommitish(ByteStringUtils.nullToEmpty((String)this.parameters.getSinceCommitId().orElse(null))).setUntilCommitish(ByteString.copyFromUtf8((String)this.parameters.getUntilCommitId()));
            this.applyTimeouts(arg_0 -> ((RpcBatchChangesRequest.Builder)builder).setTimeouts(arg_0));
            this.batchClient.changes(this.repository, builder, (BatchChangeCallback)new BatchWritingBulkContentCallback(this.callback, writer));
        }
        catch (IOException e) {
            log.error("Failed writing file changes file for bulk content command", (Throwable)e);
            return CommandResult.FAILED;
        }
        return CommandResult.SUCCEEDED;
    }

    private CommandResult streamToCallback(Repository repository, Path metadata) {
        CommandResult commandResult;
        block8: {
            BufferedReader reader = Files.newBufferedReader(metadata);
            try {
                RpcCatFileBatchRequest.Builder builder = RpcCatFileBatchRequest.newBuilder();
                this.applyTimeouts(arg_0 -> ((RpcCatFileBatchRequest.Builder)builder).setTimeouts(arg_0));
                commandResult = (CommandResult)this.plumbingClient.catFileBatch(repository, builder, (NioStdioHandler)new FileReadingBatchCatFileStdioHandler(this.callback, this.executorService, reader));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed reading file contents for bulk content command", (Throwable)e);
                    return CommandResult.FAILED;
                }
            }
            reader.close();
        }
        return commandResult;
    }

    private class BatchWritingBulkContentCallback
    implements BatchChangeCallback {
        private final BulkContentCallback delegate;
        private final NullTerminatedWriter writer;
        private boolean isDone;

        BatchWritingBulkContentCallback(@Nonnull BulkContentCallback delegate, BufferedWriter writer) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
            this.writer = new NullTerminatedWriter((Writer)Objects.requireNonNull(writer, "writer"));
            this.isDone = false;
        }

        public void onFileChange(@Nonnull FileChangeWithSize file) {
            if (this.isDone) {
                return;
            }
            BulkContentDisposition result = this.delegate.accept((BulkFile)file);
            if (result == BulkContentDisposition.DONE) {
                this.isDone = true;
                return;
            }
            if (result == BulkContentDisposition.STREAM && file.getChangeType() != BulkChangeType.DELETE) {
                MeshBulkContentCommand.this.hasFilesToProcess = true;
                try {
                    FileChangeWithSize.write((String)file.getPath(), (BulkChangeType)file.getChangeType(), (String)file.getContentId(), (long)file.getSize(), (NullTerminatedWriter)this.writer);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }
}

