/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitContext;
import com.atlassian.bitbucket.commit.CommitSummary;
import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.commit.graph.TraversalContext;
import com.atlassian.bitbucket.commit.graph.TraversalStatus;
import com.atlassian.bitbucket.commit.graph.TraversalSummary;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommitsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListOrder;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListWalk;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTraverseCommitsRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.bulk.BulkCommitCallback;
import com.atlassian.bitbucket.scm.bulk.BulkCommitContext;
import com.atlassian.bitbucket.scm.bulk.BulkCommitSummary;
import com.atlassian.bitbucket.scm.bulk.BulkCommitsCommandParameters;
import com.atlassian.bitbucket.scm.bulk.BulkContentCallback;
import com.atlassian.bitbucket.scm.bulk.BulkContentCommandParameters;
import com.atlassian.bitbucket.scm.bulk.BulkTraversalCallback;
import com.atlassian.bitbucket.scm.bulk.BulkTraversalContext;
import com.atlassian.bitbucket.scm.bulk.BulkTraversalStatus;
import com.atlassian.bitbucket.scm.bulk.BulkTraversalSummary;
import com.atlassian.bitbucket.scm.bulk.BulkTraverseCommitsCommandParameters;
import com.atlassian.bitbucket.scm.git.command.GitBulkContentCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.util.AbstractSummary;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshBulkContentCommand;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommand;
import com.atlassian.stash.internal.scm.git.mesh.RpcBatchClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcCommitClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcPlumbingClient;
import com.google.common.collect.ImmutableSetMultimap;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class MeshGitBulkContentCommandFactory
implements GitBulkContentCommandFactory {
    private final RpcBatchClient batchClient;
    private final RpcCommitClient commitClient;
    private final GitScmConfig config;
    private final ExecutorService executorService;
    private final RpcPlumbingClient plumbingClient;
    private final GitRequestHelper requestHelper;

    public MeshGitBulkContentCommandFactory(RpcBatchClient batchClient, RpcCommitClient commitClient, GitScmConfig config, ExecutorService executorService, RpcPlumbingClient plumbingClient, GitRequestHelper requestHelper) {
        this.batchClient = batchClient;
        this.commitClient = commitClient;
        this.config = config;
        this.executorService = executorService;
        this.plumbingClient = plumbingClient;
        this.requestHelper = requestHelper;
    }

    @Nonnull
    public GitCommand<Void> commits(final @Nonnull Repository repository, final @Nonnull BulkCommitsCommandParameters parameters, final @Nonnull BulkCommitCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        final RpcGetCommitsRequest.Builder builder = RpcGetCommitsRequest.newBuilder().setFollowRenames(false).setIgnoreMissing(parameters.isIgnoringMissing()).setMaxMessageLength(parameters.isWithMessages() ? parameters.getMaxMessageLength() : 0).setWalk(RpcRevListWalk.WALK_NO_UNSORTED);
        for (Set commits : parameters.getCommits().values()) {
            builder.addAllIncludes(ByteStringUtils.toByteStringsLazily((Iterable)commits));
        }
        for (Repository alternate : parameters.getCommits().keySet()) {
            builder.addAlternates(this.requestHelper.toRepositoryId(alternate));
        }
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcGetCommitsRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitBulkContentCommandFactory.this.commitClient.getCommits(repository, builder, (CommitCallback)new ForwardingCommitCallback(parameters, callback));
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> contents(@Nonnull Repository repository, @Nonnull BulkContentCommandParameters parameters, @Nonnull BulkContentCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        return new MeshBulkContentCommand(this.batchClient, this.config, this.executorService, this.plumbingClient, repository, callback, parameters);
    }

    @Nonnull
    public GitCommand<Void> traverseCommits(final @Nonnull Repository repository, @Nonnull BulkTraverseCommitsCommandParameters parameters, final @Nonnull BulkTraversalCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        final RpcTraverseCommitsRequest.Builder builder = RpcTraverseCommitsRequest.newBuilder().addAllIncludes(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getIncludes())).setIgnoreMissing(parameters.isIgnoringMissing()).setOrder(RpcRevListOrder.ORDER_TOPOLOGICAL);
        parameters.getAlternates().forEach(repo -> builder.addAlternates(this.requestHelper.toRepositoryId(repo)));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcTraverseCommitsRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitBulkContentCommandFactory.this.commitClient.traverse(repository, builder, (TraversalCallback)new ForwardingTraversalCallback(callback));
                return null;
            }
        };
    }

    private static class ForwardingTraversalCallback
    extends TraversalCallback {
        private final BulkTraversalCallback delegate;

        ForwardingTraversalCallback(BulkTraversalCallback delegate) {
            this.delegate = delegate;
        }

        public void onEnd(@Nonnull TraversalSummary summary) {
            this.delegate.onEnd(new BulkTraversalSummary.Builder(summary.getResult()).build());
        }

        public TraversalStatus onNode(@Nonnull CommitGraphNode node) {
            BulkTraversalStatus status = this.delegate.onNode(node);
            return status == BulkTraversalStatus.FINISH ? TraversalStatus.FINISH : TraversalStatus.CONTINUE;
        }

        public void onStart(@Nonnull TraversalContext context) {
            this.delegate.onStart(new BulkTraversalContext.Builder().build());
        }
    }

    private static class ForwardingCommitCallback
    implements CommitCallback {
        private static final BulkCommitContext CONTEXT = new BulkCommitContext.Builder().build();
        private final BulkCommitCallback delegate;
        private final Map<String, Set<Repository>> repositoriesByCommit;

        ForwardingCommitCallback(BulkCommitsCommandParameters parameters, BulkCommitCallback callback) {
            this.delegate = callback;
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            parameters.getCommits().forEach((repository, commits) -> commits.forEach(commit -> builder.put(commit, repository)));
            this.repositoriesByCommit = builder.build().asMap();
        }

        public boolean onCommit(@Nonnull Commit commit) throws IOException {
            Set<Repository> repositories = this.repositoriesByCommit.get(commit.getId());
            if (repositories != null) {
                return this.delegate.onCommit(commit, repositories);
            }
            return true;
        }

        public void onEnd(@Nonnull CommitSummary summary) throws IOException {
            this.delegate.onEnd(new BulkCommitSummary.Builder((AbstractSummary)summary).build());
        }

        public void onStart(@Nonnull CommitContext context) throws IOException {
            this.delegate.onStart(CONTEXT);
        }
    }
}

