/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.scm.git.DefaultGitCommandBuilderFactory;
import com.atlassian.stash.internal.scm.git.GitCommandCreator;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.InternalGitScmCommandBuilder;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitScmCommandBuilder;
import com.atlassian.stash.internal.scm.git.mesh.MeshRepositoryArgumentCodec;
import com.atlassian.stash.internal.scm.git.mesh.RpcPlumbingClient;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public class MeshGitCommandBuilderFactory
extends DefaultGitCommandBuilderFactory {
    private final MeshRepositoryArgumentCodec argumentCodec;
    private final ExecutorService bioExecutor;
    private final GitCommandCreator commandCreator;
    private final GitScmConfig config;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RpcPlumbingClient plumbingClient;
    private final GitRequestHelper requestHelper;

    public MeshGitCommandBuilderFactory(MeshRepositoryArgumentCodec argumentCodec, ExecutorService bioExecutor, GitCommandCreator commandCreator, GitScmConfig config, ExecutorService executorService, I18nService i18nService, RpcPlumbingClient plumbingClient, GitRequestHelper requestHelper) {
        super(commandCreator, config, Collections.emptyList(), i18nService);
        this.argumentCodec = argumentCodec;
        this.bioExecutor = bioExecutor;
        this.commandCreator = commandCreator;
        this.config = config;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.plumbingClient = plumbingClient;
        this.requestHelper = requestHelper;
    }

    @Override
    @Nonnull
    public InternalGitScmCommandBuilder builder(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return new MeshGitScmCommandBuilder(this.argumentCodec, this.freeFormBuilder(repository), this.config, this.i18nService, repository);
    }

    @Override
    protected GitFreeFormCommandBuilder freeFormBuilder(Repository repository) {
        if (repository == null) {
            return super.freeFormBuilder(null);
        }
        return new MeshGitFreeFormCommandBuilder(this.i18nService, this.commandCreator, this.config, this.bioExecutor, this.executorService, this.plumbingClient, repository, this.requestHelper, this.argumentCodec);
    }
}

