/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitListMergeFilter;
import com.atlassian.bitbucket.commit.CommitOrder;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleMinimalCommit;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.content.FileContentCallback;
import com.atlassian.bitbucket.content.FileContext;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBlameRange;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBlameStreamRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBlameType;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBranchesRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCatFilePretty;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCatFileRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcChangesetPageRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateRepositoryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDeleteRepositoryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffStatsSummaryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffStreamRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffTreePageRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommitsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommonAncestorRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetNodeTypeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetObjectInfoRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetRepositorySizeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHierarchyMembership;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcListDirectoryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRefOrder;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRefsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveCommitsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveDefaultBranchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveRefsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListOrder;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListWalk;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTagsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTraverseCommitsRequest;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.BranchCallback;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefCallback;
import com.atlassian.bitbucket.repository.RefOrder;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.repository.TagCallback;
import com.atlassian.bitbucket.scm.AbstractCommitCommandParameters;
import com.atlassian.bitbucket.scm.AbstractDiffCommandParameters;
import com.atlassian.bitbucket.scm.AbstractDiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.BlameCommandParameters;
import com.atlassian.bitbucket.scm.BranchesCommandParameters;
import com.atlassian.bitbucket.scm.ChangesCommandParameters;
import com.atlassian.bitbucket.scm.ChangesetsCommandParameters;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommitCommandParameters;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.CommonAncestorCommandParameters;
import com.atlassian.bitbucket.scm.CreateCommandParameters;
import com.atlassian.bitbucket.scm.DeleteCommandParameters;
import com.atlassian.bitbucket.scm.DiffCommandParameters;
import com.atlassian.bitbucket.scm.DiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.DirectoryCommandParameters;
import com.atlassian.bitbucket.scm.FileCommandParameters;
import com.atlassian.bitbucket.scm.RawFileCommandParameters;
import com.atlassian.bitbucket.scm.RefsCommandParameters;
import com.atlassian.bitbucket.scm.RepositorySize;
import com.atlassian.bitbucket.scm.RepositorySizeCommandParameters;
import com.atlassian.bitbucket.scm.ResolveCommitsCommandParameters;
import com.atlassian.bitbucket.scm.ResolveRefCommandParameters;
import com.atlassian.bitbucket.scm.ResolveRefsCommandParameters;
import com.atlassian.bitbucket.scm.SizeCommandParameters;
import com.atlassian.bitbucket.scm.TagsCommandParameters;
import com.atlassian.bitbucket.scm.TypeCommandParameters;
import com.atlassian.bitbucket.scm.git.GitObjectType;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandFactory;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedCallback;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.scm.git.GitObjectInfo;
import com.atlassian.stash.internal.scm.git.GitRepositoryConfig;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.SimpleGitCommand;
import com.atlassian.stash.internal.scm.git.command.SupplierStdoutHandler;
import com.atlassian.stash.internal.scm.git.command.TransformedGitCommand;
import com.atlassian.stash.internal.scm.git.command.TypeDetectingStdoutHandler;
import com.atlassian.stash.internal.scm.git.command.blame.BlameFormat;
import com.atlassian.stash.internal.scm.git.command.catfile.CallbackCatFileStdoutHandler;
import com.atlassian.stash.internal.scm.git.command.revlist.SingleCommitRevListStdoutHandler;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommand;
import com.atlassian.stash.internal.scm.git.mesh.RpcCommitClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcContentClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcDiffClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcPlumbingClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcPorcelainClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcRefClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.mesh.SimpleBlameCallback;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.protobuf.ByteString;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshGitCommandFactory
implements GitCommandFactory {
    private static final Logger log = LoggerFactory.getLogger(MeshGitCommandFactory.class);
    private final RpcCommitClient commitClient;
    private final GitScmConfig config;
    private final RpcContentClient contentClient;
    private final RpcDiffClient diffClient;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RpcPlumbingClient plumbingClient;
    private final RpcPorcelainClient porcelainClient;
    private final RpcRefClient refClient;
    private final RpcRepositoryClient repositoryClient;
    private final GitRepositoryConfig repositoryConfig;
    private final GitRequestHelper requestHelper;

    public MeshGitCommandFactory(RpcCommitClient commitClient, GitScmConfig config, RpcContentClient contentClient, ExecutorService executorService, I18nService i18nService, RpcPlumbingClient plumbingClient, RpcPorcelainClient porcelainClient, RpcRefClient refClient, RpcRepositoryClient repositoryClient, RpcDiffClient diffClient, GitRepositoryConfig repositoryConfig, GitRequestHelper requestHelper) {
        this.commitClient = commitClient;
        this.config = config;
        this.contentClient = contentClient;
        this.diffClient = diffClient;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.repositoryConfig = repositoryConfig;
        this.plumbingClient = plumbingClient;
        this.porcelainClient = porcelainClient;
        this.refClient = refClient;
        this.repositoryClient = repositoryClient;
        this.requestHelper = requestHelper;
    }

    @Nonnull
    public GitCommand<Page<Blame>> blame(@Nonnull Repository repository, @Nonnull BlameCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(pageRequest, "pageRequest");
        SimpleBlameCallback callback = new SimpleBlameCallback(pageRequest);
        FileContext fileContext = new FileContext.Builder(parameters.getCommitId()).build();
        return this.blame(repository, RpcBlameType.INCREMENTAL, (AbstractCommitCommandParameters)parameters, pageRequest, fileContext, (FileContentCallback)callback, () -> ((SimpleBlameCallback)callback).getBlames());
    }

    @Nonnull
    public GitCommand<Void> branches(final @Nonnull Repository repository, @Nonnull BranchesCommandParameters parameters, final @Nonnull BranchCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        RpcRefOrder rpcRefOrder = parameters.getOrder() == RefOrder.ALPHABETICAL ? RpcRefOrder.ALPHABETICAL : RpcRefOrder.MODIFICATION;
        final RpcBranchesRequest.Builder requestBuilder = RpcBranchesRequest.newBuilder().setFilterText(StringUtils.defaultString((String)parameters.getFilterText())).setOrder(rpcRefOrder);
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcBranchesRequest.Builder)requestBuilder).setTimeouts(arg_0));
                MeshGitCommandFactory.this.refClient.branches(repository, requestBuilder, callback);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Page<Branch>> branches(final @Nonnull Repository repository, @Nonnull BranchesCommandParameters parameters, final @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(pageRequest, "pageRequest");
        RpcRefOrder rpcRefOrder = MeshGitCommandFactory.getRpcRefOrder(parameters.getOrder(), parameters.getFilterText());
        final RpcBranchesRequest.Builder requestBuilder = RpcBranchesRequest.newBuilder().setFilterText(StringUtils.defaultString((String)parameters.getFilterText())).setOrder(rpcRefOrder).setLimit(pageRequest.getLimit() + 1).setSkip(pageRequest.getStart());
        return new MeshGitCommand<Page<Branch>>(this.executorService){

            public Page<Branch> call() {
                this.applyTimeouts(arg_0 -> ((RpcBranchesRequest.Builder)requestBuilder).setTimeouts(arg_0));
                final ArrayList branches = new ArrayList(pageRequest.getLimit() + 1);
                MeshGitCommandFactory.this.refClient.branches(repository, requestBuilder, new BranchCallback(){

                    public boolean onBranch(@Nonnull Branch branch) {
                        branches.add(branch);
                        return true;
                    }
                });
                return PageUtils.createPage(branches, (PageRequest)pageRequest);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> changes(final @Nonnull Repository repository, final @Nonnull ChangesCommandParameters parameters, final @Nonnull ChangeCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        final RpcDiffTreePageRequest.Builder builder = this.prepareDiffTreeRequest(repository, parameters);
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcDiffTreePageRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitCommandFactory.this.diffClient.diffTree(repository, builder, callback, parameters.toContext());
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Page<Change>> changes(final @Nonnull Repository repository, final @Nonnull ChangesCommandParameters parameters, final @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(pageRequest, "pageRequest");
        final RpcDiffTreePageRequest.Builder builder = this.prepareDiffTreeRequest(repository, parameters);
        builder.setLimit(pageRequest.getLimit() + 1);
        builder.setSkip(pageRequest.getStart());
        return new MeshGitCommand<Page<Change>>(this.executorService){

            public Page<Change> call() {
                this.applyTimeouts(arg_0 -> ((RpcDiffTreePageRequest.Builder)builder).setTimeouts(arg_0));
                ArrayList changesPage = new ArrayList(pageRequest.getLimit() + 1);
                MeshGitCommandFactory.this.diffClient.diffTree(repository, builder, changesPage::add, parameters.toContext());
                return PageUtils.createPage(changesPage, (PageRequest)pageRequest);
            }
        };
    }

    @Nonnull
    public GitCommand<Page<Changeset>> changesets(final @Nonnull Repository repository, @Nonnull ChangesetsCommandParameters parameters, final @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(pageRequest, "pageRequest");
        if (pageRequest.getStart() > parameters.getCommitIds().size()) {
            return new SimpleGitCommand<Page<Changeset>>(this, this.executorService){

                public Page<Changeset> call() {
                    return PageUtils.createEmptyPage((PageRequest)pageRequest);
                }
            };
        }
        final RpcChangesetPageRequest.Builder builder = RpcChangesetPageRequest.newBuilder().addAllCommitIds(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getCommitIds())).setDiffOptions(this.repositoryConfig.getDiffStrategy(repository).apply(RpcDiffOptions.newBuilder())).setIgnoreMissing(parameters.isIgnoreMissing()).setLimit(pageRequest.getLimit() + 1).setMaxChangesPerCommit(parameters.getMaxChangesPerCommit()).setMaxMessageLength(parameters.getMaxMessageLength()).setSkip(pageRequest.getStart());
        return new MeshGitCommand<Page<Changeset>>(this.executorService){

            public Page<Changeset> call() {
                this.applyTimeouts(arg_0 -> ((RpcChangesetPageRequest.Builder)builder).setTimeouts(arg_0));
                ArrayList changesetPage = new ArrayList(pageRequest.getLimit() + 1);
                MeshGitCommandFactory.this.diffClient.changesets(repository, builder, changesetPage::add);
                return PageUtils.createPage(changesetPage, (PageRequest)pageRequest);
            }
        };
    }

    @Nonnull
    public GitCommand<Commit> commit(final @Nonnull Repository repository, @Nonnull CommitCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        String commitId = parameters.getCommitId();
        String path = parameters.getPath();
        final SingleCommitRevListStdoutHandler handler = new SingleCommitRevListStdoutHandler(this.i18nService, repository, commitId, parameters.hasPath() ? path : null, parameters.getMaxMessageLength() != 0, false, parameters.getMaxMessageLength());
        RpcRevListOptions.Builder optionsBuilder = RpcRevListOptions.newBuilder().setFormat(handler.getFormat());
        if (parameters.hasPath()) {
            optionsBuilder.addPaths(ByteStringUtils.nullToEmpty((String)path)).addRevs(ByteString.copyFromUtf8((String)commitId)).setLimit(1);
        } else {
            optionsBuilder.addRevs(ByteString.copyFromUtf8((String)commitId)).addRevs(ByteString.copyFromUtf8((String)(commitId + "^@"))).setWalk(RpcRevListWalk.WALK_NO_UNSORTED);
        }
        final RpcRevListRequest.Builder builder = RpcRevListRequest.newBuilder().setRevListOptions(optionsBuilder);
        return new MeshGitCommand<Commit>(this.executorService){

            public Commit call() {
                this.applyTimeouts(arg_0 -> ((RpcRevListRequest.Builder)builder).setTimeouts(arg_0));
                return (Commit)MeshGitCommandFactory.this.plumbingClient.revList(repository, builder, (NioStdoutHandler)handler);
            }
        };
    }

    @Nonnull
    public GitCommand<Page<Commit>> commits(@Nonnull Repository repository, @Nonnull CommitsCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(pageRequest, "pageRequest");
        ArrayList commits = new ArrayList();
        return new TransformedGitCommand<Void, Page>(this.getCommits(repository, parameters, commits::add, pageRequest), ignored -> PageUtils.createPage((Iterable)commits, (PageRequest)pageRequest));
    }

    @Nonnull
    public GitCommand<Void> commits(@Nonnull Repository repository, @Nonnull CommitsCommandParameters parameters, @Nonnull CommitCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        PageRequest pageRequest = null;
        if (callback instanceof PagedCallback) {
            PagedCallback pagedCallback = (PagedCallback)callback;
            pageRequest = pagedCallback.getPageRequest();
            pagedCallback.paged();
        }
        return this.getCommits(repository, parameters, callback, pageRequest);
    }

    @Nonnull
    public GitCommand<MinimalCommit> commonAncestor(final @Nonnull Repository repository, @Nonnull CommonAncestorCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final Set commitIds = parameters.getCommitIds();
        if (commitIds.size() == 1) {
            return new SimpleGitCommand<MinimalCommit>(this, this.executorService){

                public MinimalCommit call() {
                    return new SimpleMinimalCommit.Builder((String)Iterables.getOnlyElement((Iterable)commitIds)).build();
                }
            };
        }
        final RpcGetCommonAncestorRequest.Builder builder = RpcGetCommonAncestorRequest.newBuilder().addAllCommitishes(ByteStringUtils.toByteStringsLazily((Iterable)commitIds));
        Repository related = parameters.getSecondaryRepository();
        if (related != null) {
            builder.addAlternates(this.requestHelper.toRepositoryId(related));
        }
        return new MeshGitCommand<MinimalCommit>(this.executorService){

            public MinimalCommit call() {
                this.applyTimeouts(arg_0 -> ((RpcGetCommonAncestorRequest.Builder)builder).setTimeouts(arg_0));
                return MeshGitCommandFactory.this.commitClient.getCommonAncestor(repository, builder);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> create(final @Nonnull Repository repository, @Nonnull CreateCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final RpcCreateRepositoryRequest.Builder builder = RpcCreateRepositoryRequest.newBuilder();
        if (parameters.getDefaultBranch() != null) {
            builder.setDefaultBranch(ByteString.copyFromUtf8((String)parameters.getDefaultBranch()));
        }
        builder.putMetadata("hierarchy", repository.getHierarchyId()).putMetadata("project", repository.getProject().getKey()).putMetadata("repository", repository.getSlug());
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                MeshGitCommandFactory.this.repositoryClient.create(repository, builder);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Branch> defaultBranch(final @Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        final RpcResolveDefaultBranchRequest.Builder builder = RpcResolveDefaultBranchRequest.newBuilder();
        return new MeshGitCommand<Branch>(this.executorService){

            public Branch call() {
                this.applyTimeouts(arg_0 -> ((RpcResolveDefaultBranchRequest.Builder)builder).setTimeouts(arg_0));
                return MeshGitCommandFactory.this.refClient.resolveDefaultBranch(repository, builder);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> delete(final @Nonnull Repository repository, final @Nonnull DeleteCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                RpcDeleteRepositoryRequest.Builder builder = RpcDeleteRepositoryRequest.newBuilder();
                if (repository.isLocal()) {
                    RpcHierarchyMembership.Builder membershipBuilder = RpcHierarchyMembership.newBuilder().setOnlyMember(parameters.isLastInHierarchy());
                    if (repository.getOrigin() != null) {
                        membershipBuilder.setOrigin(MeshGitCommandFactory.this.requestHelper.toRepositoryId(repository.getOrigin())).setOnlyForkOfOrigin(parameters.isLastForkOfOrigin());
                    }
                    if (parameters.hasForks()) {
                        String prefix = StringUtils.stripEnd((String)MeshGitCommandFactory.this.requestHelper.toRepositoryId(repository), (String)Integer.toString(repository.getId()));
                        parameters.getForkIds().forEach(id -> membershipBuilder.addForks(prefix + id));
                    }
                    builder.setHierarchyMembership(membershipBuilder);
                }
                MeshGitCommandFactory.this.repositoryClient.delete(repository, builder);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> diff(final @Nonnull Repository repository, final @Nonnull DiffCommandParameters parameters, final @Nonnull DiffContentCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        final RpcDiffStreamRequest.Builder builder = RpcDiffStreamRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getPaths())).setAncestor(ByteStringUtils.nullToEmpty((String)parameters.getSinceId())).setDiffOptions(this.repositoryConfig.getDiffStrategy(repository).apply(RpcUtils.prepareDiffOptions((AbstractDiffCommandParameters)parameters))).setMaxLineLength(parameters.getMaxLineLength()).setMaxLines(parameters.getMaxLines()).setRev(ByteString.copyFromUtf8((String)parameters.getUntilId()));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcDiffStreamRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitCommandFactory.this.diffClient.diff(repository, builder, callback, parameters.toContext());
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> diff(final @Nonnull Repository repository, @Nonnull DiffCommandParameters parameters, @Nonnull TypeAwareOutputSupplier outputSupplier) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(outputSupplier, "outputSupplier");
        final RpcDiffRequest.Builder builder = this.prepareDiffRequest(repository, parameters);
        final SupplierStdoutHandler handler = new SupplierStdoutHandler(outputSupplier);
        Repository related = parameters.getSecondaryRepository();
        if (related != null) {
            this.checkSameHierarchy(repository, related, "diff");
            builder.setOptions(RpcGitOptions.newBuilder().addAlternates(this.requestHelper.toRepositoryId(related)));
        }
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcDiffRequest.Builder)builder).setTimeouts(arg_0));
                return (Void)MeshGitCommandFactory.this.porcelainClient.diff(repository, builder, (NioStdoutHandler)handler);
            }
        };
    }

    @Nonnull
    public GitCommand<DiffStatsSummary> diffStatsSummary(final @Nonnull Repository repository, @Nonnull DiffStatsSummaryCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final RpcDiffStatsSummaryRequest.Builder builder = this.prepareDiffStatsSummaryRequest(repository, parameters);
        Repository related = parameters.getSecondaryRepository();
        if (related != null) {
            this.checkSameHierarchy(repository, related, "diff");
            builder.setOptions(RpcGitOptions.newBuilder().addAlternates(this.requestHelper.toRepositoryId(related)));
        }
        return new MeshGitCommand<DiffStatsSummary>(this.executorService){

            public DiffStatsSummary call() {
                this.applyTimeouts(arg_0 -> ((RpcDiffStatsSummaryRequest.Builder)builder).setTimeouts(arg_0));
                return MeshGitCommandFactory.this.porcelainClient.diffStatsSummary(repository, builder);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> directory(final @Nonnull Repository repository, @Nonnull DirectoryCommandParameters parameters, final @Nonnull ContentTreeCallback callback, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(pageRequest, "pageRequest");
        final RpcListDirectoryRequest.Builder builder = RpcListDirectoryRequest.newBuilder().setCommitish(ByteString.copyFromUtf8((String)parameters.getCommitId())).setLimit(pageRequest.getLimit() + 1).setPath(ByteStringUtils.nullToEmpty((String)parameters.getPath())).setRecursive(parameters.isRecursive()).setSizes(parameters.isWithSizes()).setSkip(pageRequest.getStart());
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcListDirectoryRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitCommandFactory.this.contentClient.listDirectory(repository, builder, callback);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> file(final @Nonnull Repository repository, @Nonnull FileCommandParameters parameters, @Nonnull FileContentCallback callback, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(pageRequest, "pageRequest");
        String commitId = parameters.getCommitId();
        String path = parameters.getPath();
        FileContext context = parameters.toContext();
        if (parameters.isAnnotated()) {
            log.debug("Using git blame to retrieve content and blame for {} at {}", (Object)path, (Object)commitId);
            return this.blame(repository, RpcBlameType.PORCELAIN, (AbstractCommitCommandParameters)parameters, pageRequest, context, callback, () -> null);
        }
        log.debug("Using git cat-file to retrieve content for {} at {}", (Object)path, (Object)commitId);
        final RpcCatFileRequest.Builder builder = RpcCatFileRequest.newBuilder().setPretty(RpcCatFilePretty.newBuilder().setObjectId(ByteString.copyFromUtf8((String)(commitId + ":" + StringUtils.defaultString((String)path)))));
        CallbackCatFileStdoutHandler handler = new CallbackCatFileStdoutHandler(callback, context, pageRequest);
        return new MeshGitCommand<Void>(this.executorService, (NioStdoutHandler)handler){
            final /* synthetic */ NioStdoutHandler val$handler;
            {
                this.val$handler = nioStdoutHandler;
                super(executorService);
            }

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcCatFileRequest.Builder)builder).setTimeouts(arg_0));
                return (Void)MeshGitCommandFactory.this.plumbingClient.catFile(repository, builder, this.val$handler);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> rawFile(final @Nonnull Repository repository, @Nonnull RawFileCommandParameters parameters, @Nonnull TypeAwareOutputSupplier outputStreamSupplier) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(outputStreamSupplier, "outputStreamSupplier");
        String commitId = parameters.getCommitId();
        String path = parameters.getPath();
        final RpcCatFileRequest.Builder builder = RpcCatFileRequest.newBuilder().setPretty(RpcCatFilePretty.newBuilder().setObjectId(ByteString.copyFromUtf8((String)(commitId + ":" + StringUtils.defaultString((String)path)))));
        final TypeDetectingStdoutHandler handler = new TypeDetectingStdoutHandler(outputStreamSupplier, path);
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcCatFileRequest.Builder)builder).setTimeouts(arg_0));
                return (Void)MeshGitCommandFactory.this.plumbingClient.catFile(repository, builder, handler);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> refs(final @Nonnull Repository repository, @Nonnull RefsCommandParameters parameters, final @Nonnull RefCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        final RpcRefsRequest.Builder requestBuilder = RpcRefsRequest.newBuilder();
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcRefsRequest.Builder)requestBuilder).setTimeouts(arg_0));
                MeshGitCommandFactory.this.refClient.refs(repository, requestBuilder, callback);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<RepositorySize> repositorySize(final @Nonnull Repository repository, @Nonnull RepositorySizeCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        final RpcGetRepositorySizeRequest.Builder builder = RpcGetRepositorySizeRequest.newBuilder();
        return new MeshGitCommand<RepositorySize>(this.executorService){

            public RepositorySize call() {
                this.applyTimeouts(arg_0 -> ((RpcGetRepositorySizeRequest.Builder)builder).setTimeouts(arg_0));
                return MeshGitCommandFactory.this.repositoryClient.getSize(repository, builder);
            }
        };
    }

    @Nonnull
    public Command<Map<String, String>> resolveCommits(final @Nonnull Repository repository, @Nonnull ResolveCommitsCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final RpcResolveCommitsRequest.Builder builder = RpcResolveCommitsRequest.newBuilder().addAllCommitishes(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getRevisions()));
        return new MeshGitCommand<Map<String, String>>(this.executorService){

            public Map<String, String> call() {
                this.applyTimeouts(arg_0 -> ((RpcResolveCommitsRequest.Builder)builder).setTimeouts(arg_0));
                return MeshGitCommandFactory.this.commitClient.resolveCommits(repository, builder);
            }
        };
    }

    @Nonnull
    public GitCommand<Ref> resolveRef(final @Nonnull Repository repository, @Nonnull ResolveRefCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final String refId = parameters.getRefId();
        final RpcResolveRefsRequest.Builder builder = RpcResolveRefsRequest.newBuilder();
        RefType type = parameters.getType().orElse(null);
        if (StandardRefType.BRANCH == type) {
            builder.addBranchIds(ByteString.copyFromUtf8((String)refId));
        } else if (StandardRefType.TAG == type) {
            builder.addTagIds(ByteString.copyFromUtf8((String)refId));
        } else {
            builder.addRefIds(ByteString.copyFromUtf8((String)refId));
        }
        return new MeshGitCommand<Ref>(this.executorService){

            public Ref call() {
                this.applyTimeouts(arg_0 -> ((RpcResolveRefsRequest.Builder)builder).setTimeouts(arg_0));
                return (Ref)MeshGitCommandFactory.this.refClient.resolveRefs(repository, builder).get(refId);
            }
        };
    }

    @Nonnull
    public GitCommand<Map<String, Ref>> resolveRefs(final @Nonnull Repository repository, @Nonnull ResolveRefsCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final RpcResolveRefsRequest.Builder builder = RpcResolveRefsRequest.newBuilder().addAllBranchIds(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getBranchIds())).addAllTagIds(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getTagIds())).addAllRefIds(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getRefIds()));
        return new MeshGitCommand<Map<String, Ref>>(this.executorService){

            public Map<String, Ref> call() {
                this.applyTimeouts(arg_0 -> ((RpcResolveRefsRequest.Builder)builder).setTimeouts(arg_0));
                return MeshGitCommandFactory.this.refClient.resolveRefs(repository, builder);
            }
        };
    }

    @Nonnull
    public GitCommand<Long> size(final @Nonnull Repository repository, @Nonnull SizeCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final RpcGetObjectInfoRequest.Builder builder = RpcGetObjectInfoRequest.newBuilder().setCommitish(ByteString.copyFromUtf8((String)parameters.getCommitId())).setPath(ByteStringUtils.nullToEmpty((String)parameters.getPath()));
        return new MeshGitCommand<Long>(this.executorService){

            public Long call() {
                this.applyTimeouts(arg_0 -> ((RpcGetObjectInfoRequest.Builder)builder).setTimeouts(arg_0));
                GitObjectInfo objectInfo = MeshGitCommandFactory.this.contentClient.getObjectInfo(repository, builder);
                return objectInfo.getType() == GitObjectType.BLOB ? Long.valueOf(objectInfo.getSize()) : null;
            }
        };
    }

    @Nonnull
    public GitCommand<Page<Tag>> tags(final @Nonnull Repository repository, @Nonnull TagsCommandParameters parameters, final @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(pageRequest, "pageRequest");
        RpcRefOrder rpcRefOrder = MeshGitCommandFactory.getRpcRefOrder(parameters.getOrder(), parameters.getFilterText());
        final RpcTagsRequest.Builder requestBuilder = RpcTagsRequest.newBuilder().setFilterText(StringUtils.defaultString((String)parameters.getFilterText())).setOrder(rpcRefOrder).setLimit(pageRequest.getLimit() + 1).setSkip(pageRequest.getStart());
        return new MeshGitCommand<Page<Tag>>(this.executorService){

            public Page<Tag> call() {
                this.applyTimeouts(arg_0 -> ((RpcTagsRequest.Builder)requestBuilder).setTimeouts(arg_0));
                final ArrayList tags = new ArrayList(pageRequest.getLimit() + 1);
                MeshGitCommandFactory.this.refClient.tags(repository, requestBuilder, new TagCallback(){

                    public boolean onTag(@Nonnull Tag tag) {
                        tags.add(tag);
                        return true;
                    }
                });
                return PageUtils.createPage(tags, (PageRequest)pageRequest);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> tags(final @Nonnull Repository repository, @Nonnull TagsCommandParameters parameters, final @Nonnull TagCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        RpcRefOrder rpcRefOrder = MeshGitCommandFactory.getRpcRefOrder(parameters.getOrder(), parameters.getFilterText());
        final RpcTagsRequest.Builder requestBuilder = RpcTagsRequest.newBuilder().setFilterText(StringUtils.defaultString((String)parameters.getFilterText())).setOrder(rpcRefOrder);
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcTagsRequest.Builder)requestBuilder).setTimeouts(arg_0));
                MeshGitCommandFactory.this.refClient.tags(repository, requestBuilder, callback);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> traverseCommits(final @Nonnull Repository repository, final @Nonnull TraversalCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(callback, "callback");
        final RpcTraverseCommitsRequest.Builder builder = RpcTraverseCommitsRequest.newBuilder().setBranches(true).setOrder(RpcRevListOrder.ORDER_TOPOLOGICAL).setIgnoreMissing(true).setTags(true);
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcTraverseCommitsRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitCommandFactory.this.commitClient.traverse(repository, builder, callback);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<ContentTreeNode.Type> type(final @Nonnull Repository repository, @Nonnull TypeCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final RpcGetNodeTypeRequest.Builder builder = RpcGetNodeTypeRequest.newBuilder().setCommitish(ByteString.copyFromUtf8((String)parameters.getCommitId())).setPath(ByteStringUtils.nullToEmpty((String)parameters.getPath()));
        return new MeshGitCommand<ContentTreeNode.Type>(this.executorService){

            public ContentTreeNode.Type call() {
                this.applyTimeouts(arg_0 -> ((RpcGetNodeTypeRequest.Builder)builder).setTimeouts(arg_0));
                return MeshGitCommandFactory.this.contentClient.getNodeType(repository, builder);
            }
        };
    }

    private boolean canApplyPaths(Set<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return true;
        }
        int limit = this.config.getCommandLineSize() - 250;
        int length = paths.size() - 1;
        for (String path : paths) {
            if ((length += path.length()) <= limit) continue;
            return false;
        }
        return true;
    }

    private void checkSameHierarchy(Repository left, Repository right, String action) {
        if (left.getId() != right.getId() && ObjectUtils.notEqual((Object)right.getHierarchyId(), (Object)left.getHierarchyId())) {
            I18nKey i18nKey = new I18nKey("bitbucket.git." + action + ".unrelatedrepositories", new Object[]{left.getProject().getKey(), left.getSlug(), right.getProject().getKey(), right.getSlug()});
            throw new ArgumentValidationException(this.i18nService.getKeyedText(i18nKey));
        }
    }

    private static RpcRefOrder getRpcRefOrder(RefOrder order, String filterText) {
        if (order == null) {
            return StringUtils.isBlank((CharSequence)filterText) ? RpcRefOrder.MODIFICATION : RpcRefOrder.ALPHABETICAL;
        }
        return order == RefOrder.ALPHABETICAL ? RpcRefOrder.ALPHABETICAL : RpcRefOrder.MODIFICATION;
    }

    private RpcDiffRequest.Builder prepareDiffRequest(Repository repository, DiffCommandParameters parameters) {
        return RpcDiffRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getPaths())).setAncestor(ByteStringUtils.nullToEmpty((String)parameters.getSinceId())).setDiffOptions(this.repositoryConfig.getDiffStrategy(repository).apply(RpcUtils.prepareDiffOptions((AbstractDiffCommandParameters)parameters))).setRev(ByteString.copyFromUtf8((String)parameters.getUntilId()));
    }

    private RpcDiffStatsSummaryRequest.Builder prepareDiffStatsSummaryRequest(Repository repository, DiffStatsSummaryCommandParameters parameters) {
        return RpcDiffStatsSummaryRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getPaths())).setAncestor(ByteStringUtils.nullToEmpty((String)parameters.getSinceId())).setDiffOptions(this.repositoryConfig.getDiffStrategy(repository).apply(RpcUtils.prepareDiffOptions((AbstractDiffStatsSummaryCommandParameters)parameters))).setRev(ByteString.copyFromUtf8((String)parameters.getUntilId()));
    }

    private RpcDiffTreePageRequest.Builder prepareDiffTreeRequest(Repository repository, ChangesCommandParameters parameters) {
        RpcDiffOptions.Builder optionsBuilder = this.repositoryConfig.getDiffStrategy(repository).apply(RpcDiffOptions.newBuilder());
        RpcDiffTreePageRequest.Builder builder = RpcDiffTreePageRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getPaths())).setDiffOptions(optionsBuilder).setRecursive(true).setRev(ByteString.copyFromUtf8((String)parameters.getUntilId()));
        if (parameters.hasSinceId()) {
            builder.setAncestor(ByteStringUtils.nullToEmpty((String)parameters.getSinceId()));
        } else {
            builder.setAlways(true).setRoot(true);
        }
        return builder;
    }

    private <T> MeshGitCommand<T> blame(final Repository repository, RpcBlameType type, AbstractCommitCommandParameters parameters, final PageRequest pageRequest, final FileContext fileContext, final FileContentCallback callback, final Supplier<T> resultMappper) {
        BlameFormat format = type == RpcBlameType.INCREMENTAL ? BlameFormat.INCREMENTAL : BlameFormat.PORCELAIN;
        final RpcBlameStreamRequest.Builder builder = RpcBlameStreamRequest.newBuilder().setPath(ByteStringUtils.nullToEmpty((String)parameters.getPath())).setRange(RpcBlameRange.newBuilder().setStart(format.toLine(pageRequest.getStart())).setOffset(format.toOffset(pageRequest.getLimit()))).setRev(ByteString.copyFromUtf8((String)parameters.getCommitId())).setMaxLineLength(fileContext.getMaxLineLength()).setType(type);
        return new MeshGitCommand<T>(this.executorService){

            public T call() {
                this.applyTimeouts(arg_0 -> ((RpcBlameStreamRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitCommandFactory.this.contentClient.blame(repository, builder, fileContext, callback, pageRequest);
                return resultMappper.get();
            }
        };
    }

    private GitCommand<Void> getCommits(final Repository repository, final CommitsCommandParameters parameters, final CommitCallback callback, PageRequest pageRequest) {
        int includesExcludesCount;
        final RpcGetCommitsRequest.Builder builder = RpcGetCommitsRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getPaths())).setAll(parameters.isAll()).setFollowRenames(parameters.isFollowingRenames()).setIgnoreMissing(parameters.isIgnoringMissing()).setMaxMessageLength(parameters.isWithMessages() ? parameters.getMaxMessageLength() : 0).setMerges(RpcUtils.toRevListMerges((CommitListMergeFilter)parameters.getMerges())).setOrder(RpcUtils.toRevListOrder((CommitOrder)parameters.getOrder())).setWalk(parameters.isTraversing() ? RpcRevListWalk.WALK_DO : RpcRevListWalk.WALK_NO_UNSORTED);
        if (parameters.getSecondaryRepository() != null) {
            this.checkSameHierarchy(repository, parameters.getSecondaryRepository(), "commits");
            builder.addAlternates(this.requestHelper.toRepositoryId(parameters.getSecondaryRepository()));
        }
        if (parameters.getSince() != null) {
            builder.setSince(parameters.getSince().getEpochSecond());
        }
        if (pageRequest != null) {
            builder.setSkip(pageRequest.getStart());
            builder.setLimit(pageRequest.getLimit() + 1);
        }
        if ((includesExcludesCount = parameters.getIncludes().size() + parameters.getExcludes().size()) >= this.config.getGrpcStreamingGetCommitsThreshold()) {
            log.debug("Using streaming variant of getCommits");
            return new MeshGitCommand<Void>(this.executorService){

                public Void call() {
                    this.applyTimeouts(arg_0 -> ((RpcGetCommitsRequest.Builder)builder).setTimeouts(arg_0));
                    try {
                        MeshGitCommandFactory.this.commitClient.streamingGetCommits(repository, builder, parameters.getIncludes().iterator(), parameters.getExcludes().iterator(), callback).join();
                    }
                    catch (CompletionException e) {
                        Throwables.throwIfUnchecked((Throwable)e.getCause());
                        throw new RuntimeException(e.getCause());
                    }
                    return null;
                }
            };
        }
        builder.addAllExcludes(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getExcludes())).addAllIncludes(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getIncludes()));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcGetCommitsRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitCommandFactory.this.commitClient.getCommits(repository, builder, callback);
                return null;
            }
        };
    }
}

