/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.compare.CompareRef;
import com.atlassian.bitbucket.compare.CompareRequest;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangeContext;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffStatsSummaryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffStreamRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffTreePageRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommonAncestorRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveRefsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListRequest;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractDiffCommandParameters;
import com.atlassian.bitbucket.scm.AbstractDiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.compare.CompareChangeCommandParameters;
import com.atlassian.bitbucket.scm.compare.CompareDiffCommandParameters;
import com.atlassian.bitbucket.scm.compare.CompareDiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.git.GitUtils;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCompareCommandFactory;
import com.atlassian.stash.internal.scm.git.GitRepositoryConfig;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.revlist.CallbackRevListStdoutHandler;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommand;
import com.atlassian.stash.internal.scm.git.mesh.RpcCommitClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcDiffClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcPlumbingClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcPorcelainClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcRefClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.google.protobuf.ByteString;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class MeshGitCompareCommandFactory
implements GitCompareCommandFactory {
    private final RpcCommitClient commitClient;
    private final GitScmConfig config;
    private final RpcDiffClient diffClient;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RpcPlumbingClient plumbingClient;
    private final RpcPorcelainClient porcelainClient;
    private final RpcRefClient refClient;
    private final GitRepositoryConfig repositoryConfig;
    private final GitRequestHelper requestHelper;

    public MeshGitCompareCommandFactory(RpcCommitClient commitClient, GitScmConfig config, RpcDiffClient diffClient, ExecutorService executorService, I18nService i18nService, RpcPlumbingClient plumbingClient, RpcPorcelainClient porcelainClient, RpcRefClient refClient, GitRepositoryConfig repositoryConfig, GitRequestHelper requestHelper) {
        this.commitClient = commitClient;
        this.config = config;
        this.diffClient = diffClient;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.plumbingClient = plumbingClient;
        this.porcelainClient = porcelainClient;
        this.refClient = refClient;
        this.repositoryConfig = repositoryConfig;
        this.requestHelper = requestHelper;
    }

    @Nonnull
    public GitCommand<Void> changes(@Nonnull CompareRequest compareRequest, @Nonnull CompareChangeCommandParameters parameters, final @Nonnull ChangeCallback callback) {
        Objects.requireNonNull(compareRequest, "compareRequest");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        String mergeBase = this.resolveMergeBase(compareRequest);
        final ChangeContext context = this.toContext(compareRequest, parameters, mergeBase);
        CompareRef fromRef = compareRequest.getFromRef();
        final Repository repository = fromRef.getRepository();
        final RpcDiffTreePageRequest.Builder builder = this.prepareDiffTreeRequest(fromRef.getId(), mergeBase, parameters.getPaths(), repository);
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcDiffTreePageRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitCompareCommandFactory.this.diffClient.diffTree(repository, builder, callback, context);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> commits(@Nonnull CompareRequest compareRequest, @Nonnull CommitCallback callback) {
        Objects.requireNonNull(compareRequest, "compareRequest");
        Objects.requireNonNull(callback, "callback");
        CompareRef fromRef = compareRequest.getFromRef();
        CompareRef toRef = compareRequest.getToRef();
        final Repository fromRepository = fromRef.getRepository();
        Repository toRepository = toRef.getRepository();
        final CallbackRevListStdoutHandler handler = new CallbackRevListStdoutHandler(toRepository, callback, this.config.getMaxMessageLength());
        final RpcRevListRequest.Builder builder = this.prepareRevListRequest(fromRepository, fromRef.getId(), handler.getFormat(), toRepository, toRef.getId());
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcRevListRequest.Builder)builder).setTimeouts(arg_0));
                return (Void)MeshGitCompareCommandFactory.this.plumbingClient.revList(fromRepository, builder, (NioStdoutHandler)handler);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> diff(@Nonnull CompareRequest compareRequest, @Nonnull CompareDiffCommandParameters parameters, final @Nonnull DiffContentCallback callback) {
        Objects.requireNonNull(compareRequest, "compareRequest");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        String mergeBase = this.resolveMergeBase(compareRequest);
        final DiffContext context = this.toContext(compareRequest, parameters, mergeBase);
        final Repository repository = compareRequest.getFromRef().getRepository();
        final RpcDiffStreamRequest.Builder builder = RpcDiffStreamRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getPaths())).setAncestor(ByteString.copyFromUtf8((String)mergeBase)).setDiffOptions(this.repositoryConfig.getDiffStrategy(repository).apply(RpcUtils.prepareDiffOptions((AbstractDiffCommandParameters)parameters))).setMaxLineLength(parameters.getMaxLineLength()).setMaxLines(parameters.getMaxLines()).setRev(ByteString.copyFromUtf8((String)compareRequest.getFromRef().getId()));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcDiffStreamRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitCompareCommandFactory.this.diffClient.diff(repository, builder, callback, context);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<DiffStatsSummary> diffStatsSummary(@Nonnull CompareRequest compareRequest, @Nonnull CompareDiffStatsSummaryCommandParameters parameters) {
        Objects.requireNonNull(compareRequest, "compareRequest");
        Objects.requireNonNull(parameters, "parameters");
        String mergeBase = this.resolveMergeBase(compareRequest);
        final Repository repository = compareRequest.getFromRef().getRepository();
        final RpcDiffStatsSummaryRequest.Builder builder = this.prepareDiffStatsSummaryRequest(repository, parameters, compareRequest.getFromRef().getId(), mergeBase);
        return new MeshGitCommand<DiffStatsSummary>(this.executorService){

            public DiffStatsSummary call() {
                this.applyTimeouts(arg_0 -> ((RpcDiffStatsSummaryRequest.Builder)builder).setTimeouts(arg_0));
                return MeshGitCompareCommandFactory.this.porcelainClient.diffStatsSummary(repository, builder);
            }
        };
    }

    private RpcDiffStatsSummaryRequest.Builder prepareDiffStatsSummaryRequest(Repository repository, CompareDiffStatsSummaryCommandParameters parameters, String rev, String mergeBase) {
        return RpcDiffStatsSummaryRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getPaths())).setAncestor(ByteString.copyFromUtf8((String)mergeBase)).setDiffOptions(this.repositoryConfig.getDiffStrategy(repository).apply(RpcUtils.prepareDiffOptions((AbstractDiffStatsSummaryCommandParameters)parameters))).setRev(ByteString.copyFromUtf8((String)rev));
    }

    @Nonnull
    private String resolveMergeBase(CompareRequest compareRequest) {
        MinimalCommit commonAncestor;
        RpcResolveRefsRequest.Builder builder;
        boolean isCrossRepository;
        CompareRef fromRef = compareRequest.getFromRef();
        String fromId = fromRef.getId();
        Repository fromRepository = fromRef.getRepository();
        CompareRef toRef = compareRequest.getToRef();
        String toId = toRef.getId();
        Repository toRepository = toRef.getRepository();
        boolean bl = isCrossRepository = fromRepository.getId() != toRepository.getId();
        if (isCrossRepository && !GitUtils.isHash((String)toId)) {
            builder = RpcResolveRefsRequest.newBuilder().addRefIds(ByteString.copyFromUtf8((String)toId));
            Ref ref = (Ref)this.refClient.resolveRefs(toRepository, builder).get(toId);
            if (ref == null) {
                throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.commitnotfound", new Object[]{toRepository.getName(), toId}), toId);
            }
            toId = ref.getLatestCommit();
        }
        if (com.google.common.base.Objects.equal((Object)fromId, (Object)toId) && (!isCrossRepository || GitUtils.isHash((String)fromId))) {
            return fromId;
        }
        builder = RpcGetCommonAncestorRequest.newBuilder().addCommitishes(ByteString.copyFromUtf8((String)fromId)).addCommitishes(ByteString.copyFromUtf8((String)toId));
        if (isCrossRepository) {
            builder.addAlternates(this.requestHelper.toRepositoryId(toRepository));
        }
        if ((commonAncestor = this.commitClient.getCommonAncestor(fromRepository, (RpcGetCommonAncestorRequest.Builder)builder)) == null) {
            return "4b825dc642cb6eb9a060e54bf8d69288fbee4904";
        }
        return commonAncestor.getId();
    }

    private RpcGitOptions.Builder prepareAlternate(Repository toRepository) {
        return RpcGitOptions.newBuilder().addAlternates(this.requestHelper.toRepositoryId(toRepository));
    }

    private RpcDiffTreePageRequest.Builder prepareDiffTreeRequest(String rev, String mergeBase, Set<String> paths, Repository repository) {
        return RpcDiffTreePageRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily(paths)).setAncestor(ByteString.copyFromUtf8((String)mergeBase)).setDiffOptions(this.repositoryConfig.getDiffStrategy(repository).apply(RpcDiffOptions.newBuilder())).setMerges(false).setRecursive(true).setRev(ByteString.copyFromUtf8((String)rev));
    }

    private RpcRevListRequest.Builder prepareRevListRequest(Repository fromRepository, String fromId, String format, Repository toRepository, String toId) {
        RpcRevListRequest.Builder builder = RpcRevListRequest.newBuilder().setRevListOptions(this.prepareRevListOptions(fromId, format, toId));
        if (fromRepository.getId() != toRepository.getId()) {
            builder.setOptions(this.prepareAlternate(toRepository));
        }
        return builder;
    }

    private RpcRevListOptions.Builder prepareRevListOptions(String fromId, String format, String toId) {
        return RpcRevListOptions.newBuilder().addRevs(ByteString.copyFromUtf8((String)fromId)).addRevs(ByteString.copyFromUtf8((String)("^" + toId))).setFormat(format);
    }

    private ChangeContext toContext(CompareRequest compareRequest, CompareChangeCommandParameters parameters, String mergeBase) {
        return new ChangeContext.Builder(mergeBase, compareRequest.getFromRef().getId()).maxChanges(parameters.getMaxChanges()).build();
    }

    private DiffContext toContext(CompareRequest compareRequest, CompareDiffCommandParameters parameters, String mergeBase) {
        return parameters.toContext(compareRequest, mergeBase);
    }
}

