/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.LastModifiedCallback;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.content.ArchiveFormat;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.dmz.repository.ForkHierarchyTooDeepException;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcArchiveFormat;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcArchiveRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateRepositoryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcEditFileRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcFormatPatchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitTimeouts;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcLastModifiedRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcLsRemoteRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPrivateKeyCredentials;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPushRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRawRefsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRebaseRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRemoteRepository;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevertRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetDefaultBranchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUsernamePasswordCredentials;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.MinimalRefChange;
import com.atlassian.bitbucket.repository.RefCallback;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ArchiveCommandParameters;
import com.atlassian.bitbucket.scm.CommandFailedException;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.EditFileCommandParameters;
import com.atlassian.bitbucket.scm.ForkCommandParameters;
import com.atlassian.bitbucket.scm.LastModifiedCommandParameters;
import com.atlassian.bitbucket.scm.MergeCommandParameters;
import com.atlassian.bitbucket.scm.PatchCommandParameters;
import com.atlassian.bitbucket.scm.PushCommandParameters;
import com.atlassian.bitbucket.scm.PushContext;
import com.atlassian.bitbucket.scm.PushSummary;
import com.atlassian.bitbucket.scm.RefsCommandParameters;
import com.atlassian.bitbucket.scm.RevertCommandParameters;
import com.atlassian.bitbucket.scm.UpdateDefaultBranchCommandParameters;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.GitUtils;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitExtendedCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitRebaseCommandParameters;
import com.atlassian.bitbucket.scm.git.command.archive.GitArchiveFormat;
import com.atlassian.bitbucket.scm.ref.LsRemoteCommandParameters;
import com.atlassian.bitbucket.scm.signed.SignedObjectCallback;
import com.atlassian.bitbucket.scm.signed.SignedObjectsParameters;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.scm.git.AuthorNameType;
import com.atlassian.stash.internal.scm.git.GitRepositoryConfig;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.SupplierStdoutHandler;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommand;
import com.atlassian.stash.internal.scm.git.mesh.MeshSignedObjectsCommand;
import com.atlassian.stash.internal.scm.git.mesh.RpcCommitClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcPlumbingClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcPorcelainClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcRefClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.push.PushCallback;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.protobuf.ByteString;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class MeshGitExtendedCommandFactory
implements GitExtendedCommandFactory {
    public static final int MAX_DEPTH = 5;
    private final RpcCommitClient commitClient;
    private final GitScmConfig config;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RpcPlumbingClient plumbingClient;
    private final RpcPorcelainClient porcelainClient;
    private final RpcRefClient refClient;
    private final RpcRepositoryClient repositoryClient;
    private final GitRepositoryConfig repositoryConfig;
    private final GitRequestHelper requestHelper;

    public MeshGitExtendedCommandFactory(GitScmConfig config, RpcCommitClient commitClient, ExecutorService executorService, I18nService i18nService, RpcPlumbingClient plumbingClient, RpcPorcelainClient porcelainClient, RpcRefClient refClient, RpcRepositoryClient repositoryClient, GitRepositoryConfig repositoryConfig, GitRequestHelper requestHelper) {
        this.config = config;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.repositoryClient = repositoryClient;
        this.repositoryConfig = repositoryConfig;
        this.commitClient = commitClient;
        this.plumbingClient = plumbingClient;
        this.porcelainClient = porcelainClient;
        this.refClient = refClient;
        this.requestHelper = requestHelper;
    }

    @Nonnull
    public GitCommand<Void> archive(final @Nonnull Repository repository, @Nonnull ArchiveCommandParameters parameters, @Nonnull TypeAwareOutputSupplier outputSupplier) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(outputSupplier, "outputSupplier");
        GitArchiveFormat format = GitArchiveFormat.fromArchiveFormat((ArchiveFormat)parameters.getFormat());
        final RpcArchiveRequest.Builder builder = RpcArchiveRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getPaths())).setFormat(MeshGitExtendedCommandFactory.mapArchiveFormat(format)).setPrefix(parameters.getPrefix().orElse("")).setRev(ByteString.copyFromUtf8((String)parameters.getCommitId()));
        final SupplierStdoutHandler handler = new SupplierStdoutHandler(outputSupplier, format.getContentType());
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcArchiveRequest.Builder)builder).setTimeouts(arg_0));
                return (Void)MeshGitExtendedCommandFactory.this.porcelainClient.archive(repository, builder, (NioStdoutHandler)handler);
            }
        };
    }

    @Nonnull
    public GitCommand<Commit> editFile(final @Nonnull Repository repository, final @Nonnull EditFileCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        AuthorNameType nameType = this.repositoryConfig.getAuthorNameType(repository);
        final RpcEditFileRequest.Builder builder = RpcEditFileRequest.newBuilder().setAuthor(RpcUtils.toPerson((Person)nameType.convert((Person)parameters.getAuthor()))).setCommitter(RpcUtils.toPerson((Person)nameType.convert((Person)parameters.getCommitter()))).setMessage(ByteString.copyFromUtf8((String)parameters.getMessage())).setPath(ByteString.copyFromUtf8((String)parameters.getPath())).setTargetBranch(ByteString.copyFromUtf8((String)parameters.getTargetBranch()));
        parameters.getBranch().ifPresent(branch -> builder.setBranch(RpcUtils.toBranch((Branch)branch)));
        parameters.getSourceCommitId().ifPresent(id -> builder.setSourceCommitish(ByteString.copyFromUtf8((String)id)));
        return new MeshGitCommand<Commit>(this.executorService){

            public Commit call() {
                this.applyTimeouts(arg_0 -> ((RpcEditFileRequest.Builder)builder).setTimeouts(arg_0));
                Commit commit = MeshGitExtendedCommandFactory.this.commitClient.editFile(repository, builder, parameters.getContent());
                return new SimpleCommit.Builder(commit).author((Person)parameters.getAuthor()).committer((Person)parameters.getCommitter()).build();
            }
        };
    }

    @Nonnull
    public GitCommand<Void> fork(final @Nonnull Repository repository, @Nonnull ForkCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final RpcCreateRepositoryRequest.Builder builder = RpcCreateRepositoryRequest.newBuilder().setOrigin(this.requestHelper.toRepositoryId(repository));
        if (parameters.getDefaultBranch() != null) {
            builder.setDefaultBranch(ByteString.copyFromUtf8((String)parameters.getDefaultBranch()));
        }
        final Repository fork = parameters.getFork();
        builder.putMetadata("hierarchy", fork.getHierarchyId()).putMetadata("project", fork.getProject().getKey()).putMetadata("repository", fork.getSlug());
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcCreateRepositoryRequest.Builder)builder).setTimeouts(arg_0));
                try {
                    MeshGitExtendedCommandFactory.this.repositoryClient.create(fork, builder);
                }
                catch (ForkHierarchyTooDeepException e) {
                    Repository grandparent = repository.getOrigin();
                    if (grandparent == null) {
                        throw new CommandFailedException(MeshGitExtendedCommandFactory.this.i18nService.createKeyedMessage("bitbucket.git.fork.toodeep.hiddenparents", new Object[]{repository.getProject().getKey(), repository.getSlug(), 5}));
                    }
                    throw new CommandFailedException(MeshGitExtendedCommandFactory.this.i18nService.createKeyedMessage("bitbucket.git.fork.toodeep.useparent", new Object[]{repository.getProject().getKey(), repository.getSlug(), 5, grandparent.getProject().getKey(), grandparent.getSlug()}));
                }
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> lastModified(final @Nonnull Repository repository, @Nonnull LastModifiedCommandParameters parameters, final @Nonnull LastModifiedCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        final RpcLastModifiedRequest.Builder builder = RpcLastModifiedRequest.newBuilder().setCommitish(ByteString.copyFromUtf8((String)parameters.getCommitId())).setMaxMessageLength(parameters.getMaxMessageLength()).setPath(ByteStringUtils.nullToEmpty((String)parameters.getPath()));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcLastModifiedRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitExtendedCommandFactory.this.commitClient.lastModified(repository, builder, callback);
                return null;
            }
        };
    }

    @Nonnull
    public MeshGitCommand<Void> lsRemote(final @Nonnull Repository repository, @Nonnull LsRemoteCommandParameters parameters, final @Nonnull RefCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        RpcRemoteRepository.Builder remoteRepository = RpcRemoteRepository.newBuilder().setUrl(parameters.getCloneUrl());
        MeshGitExtendedCommandFactory.setCredentials(remoteRepository, parameters);
        final RpcLsRemoteRequest.Builder requestBuilder = RpcLsRemoteRequest.newBuilder().setRemoteRepository(remoteRepository).setTimeouts(RpcGitTimeouts.newBuilder().setExecution(parameters.getSyncTimeout().toSeconds()).setIdle(parameters.getIdleTimeout().toSeconds()).build()).setOptions(RpcGitOptions.newBuilder().putAllEnvironment(ByteStringUtils.toByteStringsLazily((Map)parameters.getEnvironment())));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcLsRemoteRequest.Builder)requestBuilder).setTimeouts(arg_0));
                MeshGitExtendedCommandFactory.this.refClient.lsRemote(repository, requestBuilder, callback);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Branch> merge(final @Nonnull Repository repository, final @Nonnull MergeCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final Repository fromRepository = parameters.getFromRepository();
        if (fromRepository != null) {
            this.checkSameHierarchy(repository, fromRepository, "merge");
        }
        AuthorNameType nameType = this.repositoryConfig.getAuthorNameType(repository);
        final RpcMergeRequest.Builder builder = RpcMergeRequest.newBuilder().setAllowUnrelated(true).setAuthor(RpcUtils.toPerson((Person)nameType.convert((Person)parameters.getAuthor()))).setCommitter(RpcUtils.toPerson((Person)nameType.convert((Person)parameters.getCommitter()))).setFromBranch(ByteString.copyFromUtf8((String)parameters.getFromBranch())).setFromCommitId(StringUtils.defaultString((String)parameters.getFromCommitId())).setLog(parameters.getCommitSummaries()).setMaxMessageLength(this.config.getMaxMessageLength()).setMessage(ByteStringUtils.nullToEmpty((String)parameters.getMessage())).setToBranch(ByteString.copyFromUtf8((String)parameters.getToBranch())).setToCommitId(StringUtils.defaultString((String)parameters.getToCommitId()));
        return new MeshGitCommand<Branch>(this.executorService){

            public Branch call() {
                this.applyTimeouts(arg_0 -> ((RpcMergeRequest.Builder)builder).setTimeouts(arg_0));
                if (parameters.isDryRun()) {
                    MeshGitExtendedCommandFactory.this.commitClient.tryMerge(repository, fromRepository, builder, parameters.getStrategyId());
                    return null;
                }
                return MeshGitExtendedCommandFactory.this.commitClient.merge(repository, fromRepository, builder, parameters.getStrategyId());
            }
        };
    }

    @Nonnull
    public GitCommand<Void> patch(final @Nonnull Repository repository, @Nonnull PatchCommandParameters parameters, @Nonnull TypeAwareOutputSupplier outputSupplier) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(outputSupplier, "outputSupplier");
        final RpcFormatPatchRequest.Builder builder = RpcFormatPatchRequest.newBuilder();
        if (parameters.isAllAncestors()) {
            builder.setAllAncestors(true);
        } else {
            builder.setAncestor(ByteStringUtils.nullToEmpty((String)parameters.getSinceId()));
        }
        builder.setRev(ByteString.copyFromUtf8((String)parameters.getUntilId()));
        final SupplierStdoutHandler handler = new SupplierStdoutHandler(outputSupplier);
        Repository related = parameters.getSecondaryRepository();
        if (related != null) {
            this.checkSameHierarchy(repository, related, "patch");
            builder.setOptions(RpcGitOptions.newBuilder().addAlternates(this.requestHelper.toRepositoryId(related)).build());
        }
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcFormatPatchRequest.Builder)builder).setTimeouts(arg_0));
                return (Void)MeshGitExtendedCommandFactory.this.porcelainClient.formatPatch(repository, builder, (NioStdoutHandler)handler);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> push(final @Nonnull Repository repository, @Nonnull PushCommandParameters parameters, final @Nonnull com.atlassian.bitbucket.scm.PushCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        RpcRemoteRepository.Builder remoteRepository = RpcRemoteRepository.newBuilder().setUrl(parameters.getRemoteUrl());
        MeshGitExtendedCommandFactory.setCredentials(remoteRepository, parameters);
        final RpcPushRequest.Builder request = RpcPushRequest.newBuilder().addAllRefspecs(ByteStringUtils.toByteStringsLazily(MeshGitExtendedCommandFactory.getRefspecsOrDefaultToAll(parameters))).setForce(parameters.isForce()).setOptions(RpcGitOptions.newBuilder().putAllEnvironment(ByteStringUtils.toByteStringsLazily((Map)parameters.getEnvironment()))).setPrune(parameters.isPrune()).setTargetRepository(remoteRepository);
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcPushRequest.Builder)request).setTimeouts(arg_0));
                MeshGitExtendedCommandFactory.this.repositoryClient.push(repository, request, (PushCallback)new MeshPushCallback(callback));
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> rawRefs(final @Nonnull Repository repository, @Nonnull RefsCommandParameters parameters, final @Nonnull RefCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        final RpcRawRefsRequest.Builder requestBuilder = RpcRawRefsRequest.newBuilder();
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcRawRefsRequest.Builder)requestBuilder).setTimeouts(arg_0));
                MeshGitExtendedCommandFactory.this.refClient.rawRefs(repository, requestBuilder, callback);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Branch> rebase(final @Nonnull Repository repository, final @Nonnull GitRebaseCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Branch branch = Objects.requireNonNull(parameters.getBranch(), "A branch to rebase is required");
        Preconditions.checkArgument((boolean)branch.getId().startsWith(GitRefPattern.HEADS.getPath()), (String)"The specified branch, %s, is not a branch", (Object)parameters.getBranch().getId());
        String upstream = parameters.getUpstream();
        if (!GitUtils.isHash((String)upstream)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.rebase.invalidupstream", new Object[]{upstream}));
        }
        final Repository upstreamRepository = parameters.getUpstreamRepository().orElse(null);
        if (upstreamRepository != null) {
            this.checkSameHierarchy(repository, upstreamRepository, "rebase");
        }
        AuthorNameType nameType = this.repositoryConfig.getAuthorNameType(repository);
        final RpcRebaseRequest.Builder builder = RpcRebaseRequest.newBuilder().setAllowEmpty(!parameters.isCommitRequired()).setBranch(ByteString.copyFromUtf8((String)parameters.getBranch().getDisplayId())).setCommitId(parameters.getBranch().getLatestCommit()).setCommitter(RpcUtils.toPerson((Person)nameType.convert((Person)parameters.getCommitter()))).setUpstream(ByteString.copyFromUtf8((String)upstream));
        return new MeshGitCommand<Branch>(this.executorService){

            public Branch call() {
                this.applyTimeouts(arg_0 -> ((RpcRebaseRequest.Builder)builder).setTimeouts(arg_0));
                if (parameters.isDryRun()) {
                    MeshGitExtendedCommandFactory.this.commitClient.tryRebase(repository, upstreamRepository, builder);
                    return null;
                }
                return MeshGitExtendedCommandFactory.this.commitClient.rebase(repository, upstreamRepository, builder);
            }
        };
    }

    @Nonnull
    public GitCommand<Branch> revert(final @Nonnull Repository repository, @Nonnull RevertCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final RpcRevertRequest.Builder request = RpcRevertRequest.newBuilder().setBranch(RpcUtils.toBranch((Branch)parameters.getBranch())).setCommitId(parameters.getCommitId()).setCommitter(RpcUtils.toPerson((Person)parameters.getCommitter()));
        parameters.getMergedCommitParentNumber().ifPresent(arg_0 -> ((RpcRevertRequest.Builder)request).setMergedCommitParentNumber(arg_0));
        parameters.getTargetBranch().map(arg_0 -> ((GitRefPattern)GitRefPattern.HEADS).unqualify(arg_0)).ifPresent(arg_0 -> ((RpcRevertRequest.Builder)request).setTargetBranch(arg_0));
        return new MeshGitCommand<Branch>(this.executorService){

            public Branch call() {
                this.applyTimeouts(arg_0 -> ((RpcRevertRequest.Builder)request).setTimeouts(arg_0));
                return MeshGitExtendedCommandFactory.this.commitClient.revert(repository, request);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> signedObjects(@Nonnull Repository repository, @Nonnull SignedObjectsParameters parameters, @Nonnull SignedObjectCallback callback) {
        return new MeshSignedObjectsCommand(this.executorService, this.plumbingClient, repository, callback, parameters);
    }

    @Nonnull
    public GitCommand<Void> updateDefaultBranch(final @Nonnull Repository repository, @Nonnull UpdateDefaultBranchCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        final RpcSetDefaultBranchRequest.Builder builder = RpcSetDefaultBranchRequest.newBuilder().setBranchId(ByteString.copyFromUtf8((String)parameters.getBranchId()));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcSetDefaultBranchRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitExtendedCommandFactory.this.repositoryClient.setDefaultBranch(repository, builder);
                return null;
            }
        };
    }

    private static Collection<String> getRefspecsOrDefaultToAll(PushCommandParameters parameters) {
        Set refspecs = parameters.getRefspecs();
        if (refspecs.isEmpty()) {
            return parameters.isIncludePrivateRefs() ? Collections.singleton("refs/*:refs/*") : Arrays.asList("refs/heads/*:refs/heads/*", "refs/tags/*:refs/tags/*");
        }
        return refspecs;
    }

    private static RpcArchiveFormat mapArchiveFormat(GitArchiveFormat format) {
        switch (format) {
            case TAR_GZ: {
                return RpcArchiveFormat.ARCHIVE_FORMAT_TAR_GZ;
            }
            case ZIP: {
                return RpcArchiveFormat.ARCHIVE_FORMAT_ZIP;
            }
        }
        return RpcArchiveFormat.ARCHIVE_FORMAT_TAR;
    }

    private static void setCredentials(RpcRemoteRepository.Builder remoteRepository, LsRemoteCommandParameters parameters) {
        File keyFile = parameters.getPrivateKey();
        try {
            byte[] keyBytes = Files.toByteArray((File)keyFile);
            RpcPrivateKeyCredentials.Builder builder = RpcPrivateKeyCredentials.newBuilder().setPrivateKey(ByteString.copyFrom((byte[])keyBytes));
            remoteRepository.setPrivateKey(builder);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new IllegalArgumentException("Private key file " + String.valueOf(keyFile) + " not found");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Private key file " + String.valueOf(keyFile) + " could not be read", e);
        }
    }

    private static void setCredentials(RpcRemoteRepository.Builder remoteRepository, PushCommandParameters parameters) {
        if (parameters.isAnonymous()) {
            return;
        }
        if (parameters.getPrivateKey().isPresent()) {
            File keyFile = (File)parameters.getPrivateKey().get();
            try {
                byte[] keyBytes = Files.toByteArray((File)((File)parameters.getPrivateKey().get()));
                RpcPrivateKeyCredentials.Builder builder = RpcPrivateKeyCredentials.newBuilder().setPrivateKey(ByteString.copyFrom((byte[])keyBytes));
                parameters.getPassword().ifPresent(password -> builder.setPassword(ByteString.copyFromUtf8((String)password)));
                parameters.getUsername().ifPresent(username -> builder.setUsername(ByteString.copyFromUtf8((String)username)));
                remoteRepository.setPrivateKey(builder);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                throw new IllegalArgumentException("Private key file " + String.valueOf(keyFile) + " not found");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Private key file " + String.valueOf(keyFile) + " could not be read", e);
            }
        } else {
            RpcUsernamePasswordCredentials.Builder builder = RpcUsernamePasswordCredentials.newBuilder();
            parameters.getPassword().ifPresent(password -> builder.setPassword(ByteString.copyFromUtf8((String)password)));
            parameters.getUsername().ifPresent(username -> builder.setUsername(ByteString.copyFromUtf8((String)username)));
            remoteRepository.setUsernamePassword(builder.build());
        }
    }

    private void checkSameHierarchy(Repository left, Repository right, String action) {
        if (left.getId() != right.getId() && ObjectUtils.notEqual((Object)right.getHierarchyId(), (Object)left.getHierarchyId())) {
            I18nKey i18nKey = new I18nKey("bitbucket.git." + action + ".unrelatedrepositories", new Object[]{left.getProject().getKey(), left.getSlug(), right.getProject().getKey(), right.getSlug()});
            throw new ArgumentValidationException(this.i18nService.getKeyedText(i18nKey));
        }
    }

    private static class MeshPushCallback
    implements PushCallback {
        private final com.atlassian.bitbucket.scm.PushCallback delegate;

        private MeshPushCallback(com.atlassian.bitbucket.scm.PushCallback delegate) {
            this.delegate = delegate;
        }

        public void onEnd(@Nonnull CommandResult result) throws IOException {
            this.delegate.onEnd(new PushSummary.Builder(result).build());
        }

        public void onFailedRef(@Nonnull MinimalRef ref) throws IOException {
            this.delegate.onFailedRef(ref);
        }

        public void onRefChange(@Nonnull MinimalRefChange refChange) throws IOException {
            this.delegate.onRefChange(refChange);
        }

        public void onProgress(@Nonnull Progress progress) throws IOException {
            this.delegate.onProgress(progress);
        }

        public void onStart() throws IOException {
            this.delegate.onStart(new PushContext.Builder().build());
        }
    }
}

