/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.process.CompositeNioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioStderrHandler;
import com.atlassian.bitbucket.dmz.process.NioStdinHandler;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.dmz.process.StdinHandlerFactory;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCallRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitOptions;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTree;
import com.atlassian.stash.internal.scm.git.GitCommandCreator;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.BioStdioHandler;
import com.atlassian.stash.internal.scm.git.command.CommandHandlerType;
import com.atlassian.stash.internal.scm.git.command.DefaultGitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.LatchedNioStdioHandler;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommand;
import com.atlassian.stash.internal.scm.git.mesh.MeshRepositoryArgumentCodec;
import com.atlassian.stash.internal.scm.git.mesh.RpcPlumbingClient;
import com.atlassian.stash.internal.scm.git.mesh.worktree.MeshGitWorkTree;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class MeshGitFreeFormCommandBuilder
extends DefaultGitFreeFormCommandBuilder {
    private final MeshRepositoryArgumentCodec argumentCodec;
    private final ExecutorService bioExecutor;
    private final ExecutorService executorService;
    private final RpcPlumbingClient plumbingClient;
    private final GitRequestHelper requestHelper;

    public MeshGitFreeFormCommandBuilder(@Nonnull I18nService i18nService, @Nonnull GitCommandCreator commandCreator, @Nonnull GitScmConfig config, @Nonnull ExecutorService bioExecutor, @Nonnull ExecutorService executorService, @Nonnull RpcPlumbingClient plumbingClient, @Nonnull Repository repository, @Nonnull GitRequestHelper requestHelper, @Nonnull MeshRepositoryArgumentCodec argumentCodec) {
        this(i18nService, commandCreator, config, bioExecutor, executorService, plumbingClient, requestHelper, argumentCodec, Objects.requireNonNull(repository, "repository"), null);
    }

    public MeshGitFreeFormCommandBuilder(@Nonnull I18nService i18nService, @Nonnull GitCommandCreator commandCreator, @Nonnull GitScmConfig config, @Nonnull ExecutorService bioExecutor, @Nonnull ExecutorService executorService, @Nonnull RpcPlumbingClient plumbingClient, @Nonnull GitWorkTree workTree, @Nonnull GitRequestHelper requestHelper, @Nonnull MeshRepositoryArgumentCodec argumentCodec) {
        this(i18nService, commandCreator, config, bioExecutor, executorService, plumbingClient, requestHelper, argumentCodec, null, Objects.requireNonNull(workTree, "workTree"));
    }

    private MeshGitFreeFormCommandBuilder(@Nonnull I18nService i18nService, @Nonnull GitCommandCreator commandCreator, @Nonnull GitScmConfig config, @Nonnull ExecutorService bioExecutor, @Nonnull ExecutorService executorService, @Nonnull RpcPlumbingClient plumbingClient, @Nonnull GitRequestHelper requestHelper, @Nonnull MeshRepositoryArgumentCodec argumentCodec, @Nullable Repository repository, @Nullable GitWorkTree workTree) {
        super(i18nService, commandCreator, config, repository, workTree);
        this.argumentCodec = Objects.requireNonNull(argumentCodec, "argumentDecoder");
        this.bioExecutor = Objects.requireNonNull(bioExecutor, "bioExecutor");
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        this.plumbingClient = Objects.requireNonNull(plumbingClient, "plumbingClient");
        this.requestHelper = Objects.requireNonNull(requestHelper, "requestHelper");
    }

    @Override
    @Nonnull
    public <T> GitCommand<T> build(@Nonnull CommandOutputHandler<T> outputHandler) {
        ArrayList<String> effectiveArguments = new ArrayList<String>(this.arguments);
        String effectiveCommand = this.getEffectiveCommand(effectiveArguments);
        HashMap<String, String> effectiveEnvironment = new HashMap<String, String>(this.environment);
        if (this.shouldApplyQuarantine()) {
            this.applyQuarantine(effectiveEnvironment);
        }
        GitCommandExitHandler effectiveExitHandler = this.exitHandler == null ? this.createExitHandler() : this.exitHandler;
        final LatchedNioStdioHandler<T> effectiveOutputHandler = this.prepareHandlers(outputHandler);
        final RpcCallRequest.Builder builder = RpcCallRequest.newBuilder().addAllArguments((Iterable)ByteStringUtils.toByteStringsLazily(effectiveArguments)).setCommand(effectiveCommand).setOptions(this.buildOptions(effectiveEnvironment));
        MeshGitCommand command = new MeshGitCommand<T>(this.executorService, (CommandExitHandler)effectiveExitHandler){
            final /* synthetic */ CommandExitHandler val$effectiveExitHandler;
            {
                this.val$effectiveExitHandler = commandExitHandler;
                super(executorService);
            }

            public T call() {
                this.applyTimeouts(arg_0 -> ((RpcCallRequest.Builder)builder).setTimeouts(arg_0));
                if (MeshGitFreeFormCommandBuilder.this.workTree != null) {
                    return MeshGitFreeFormCommandBuilder.this.plumbingClient.call((MeshGitWorkTree)MeshGitFreeFormCommandBuilder.this.workTree, builder, (NioStdioHandler)effectiveOutputHandler, this.val$effectiveExitHandler);
                }
                return MeshGitFreeFormCommandBuilder.this.plumbingClient.call(MeshGitFreeFormCommandBuilder.this.repository, MeshGitFreeFormCommandBuilder.this.argumentCodec.decodeRemoteRepositories(MeshGitFreeFormCommandBuilder.this.arguments), builder, (NioStdioHandler)effectiveOutputHandler, this.val$effectiveExitHandler);
            }

            @Override
            @Nonnull
            public Future<T> start() {
                Future future = this.executorService.submit(this);
                effectiveOutputHandler.awaitStart();
                return future;
            }
        };
        MeshGitFreeFormCommandBuilder.maybeSetCommand(this.errorHandler, command);
        MeshGitFreeFormCommandBuilder.maybeSetCommand(this.inputHandler, command);
        MeshGitFreeFormCommandBuilder.maybeSetCommand(outputHandler, command);
        effectiveOutputHandler.setCommand((Command<?>)command);
        return command;
    }

    @Override
    protected Path directoryExistsOrIsNull(Path value) {
        return null;
    }

    private RpcGitOptions.Builder buildOptions(Map<String, String> effectiveEnvironment) {
        RpcGitOptions.Builder options = RpcGitOptions.newBuilder();
        this.alternates.stream().map(arg_0 -> ((GitRequestHelper)this.requestHelper).toRepositoryId(arg_0)).forEach(arg_0 -> ((RpcGitOptions.Builder)options).addAlternates(arg_0));
        return options.putAllConfig(ByteStringUtils.toByteStringsLazily((Map)this.configuration)).putAllEnvironment(ByteStringUtils.toByteStringsLazily(effectiveEnvironment));
    }

    private <T> LatchedNioStdioHandler<T> prepareHandlers(CommandOutputHandler<T> outputHandler) {
        CompositeNioStdioHandler effectiveHandler;
        CommandHandlerType stderrType = CommandHandlerType.forHandler(this.errorHandler);
        CommandHandlerType stdinType = CommandHandlerType.forHandler(this.inputHandler);
        CommandHandlerType stdoutType = CommandHandlerType.forHandler(outputHandler);
        if (stderrType == CommandHandlerType.BIO || stdinType == CommandHandlerType.BIO || stdoutType == CommandHandlerType.BIO) {
            effectiveHandler = new BioStdioHandler(this.bioExecutor, this.i18nService, this.inputHandler, outputHandler, this.errorHandler);
        } else if (outputHandler instanceof NioStdioHandler) {
            effectiveHandler = (CompositeNioStdioHandler)outputHandler;
        } else {
            if (stdinType == CommandHandlerType.FACTORY) {
                this.inputHandler = ((StdinHandlerFactory)this.inputHandler).createForNio();
            }
            effectiveHandler = new CompositeNioStdioHandler((NioStdoutHandler)outputHandler, (NioStdinHandler)this.inputHandler, (NioStderrHandler)this.errorHandler);
        }
        return new LatchedNioStdioHandler<T>(effectiveHandler);
    }
}

