/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBulkVerifyRepositoryIntegrityRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcVerifyRepositoryRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.git.GitIntegrityCheckCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.integrity.IntegrityCheckCallback;
import com.atlassian.bitbucket.scm.integrity.IntegrityCheckContext;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionRegistry;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommand;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryLoader;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshGitIntegrityCheckCommandFactory
implements GitIntegrityCheckCommandFactory {
    private static final Logger log = LoggerFactory.getLogger(MeshGitIntegrityCheckCommandFactory.class);
    private final ExecutorService executorService;
    private final DmzMeshService meshService;
    private final InternalMeshPartitionRegistry partitionRegistry;
    private final RpcRepositoryClient repositoryClient;
    private final RepositorySupplier repositorySupplier;
    private final GitRequestHelper requestHelper;

    public MeshGitIntegrityCheckCommandFactory(ExecutorService executorService, DmzMeshService meshService, InternalMeshPartitionRegistry partitionRegistry, RpcRepositoryClient repositoryClient, RepositorySupplier repositorySupplier, GitRequestHelper requestHelper) {
        this.executorService = executorService;
        this.meshService = meshService;
        this.partitionRegistry = partitionRegistry;
        this.repositoryClient = repositoryClient;
        this.repositorySupplier = repositorySupplier;
        this.requestHelper = requestHelper;
    }

    @Nonnull
    public GitCommand<CommandResult> checkIntegrity(@Nonnull IntegrityCheckContext context, @Nonnull IntegrityCheckCallback callback) {
        return new MeshGitIntegrityCheckCommand(context, callback, this.executorService, this.meshService, this.partitionRegistry, this.repositoryClient, this.repositorySupplier, this.requestHelper);
    }

    private static class MeshGitIntegrityCheckCommand
    extends MeshGitCommand<CommandResult> {
        private static final int BATCH_SIZE = 50;
        private final IntegrityCheckCallback callback;
        private final IntegrityCheckContext context;
        private final DmzMeshService meshService;
        private final InternalMeshPartitionRegistry partitionRegistry;
        private final RpcRepositoryClient repositoryClient;
        private final RepositorySupplier repositorySupplier;
        private final GitRequestHelper requestHelper;

        private MeshGitIntegrityCheckCommand(IntegrityCheckContext context, IntegrityCheckCallback callback, ExecutorService executorService, DmzMeshService meshService, InternalMeshPartitionRegistry partitionRegistry, RpcRepositoryClient repositoryClient, RepositorySupplier repositorySupplier, GitRequestHelper requestHelper) {
            super(executorService);
            this.context = context;
            this.callback = callback;
            this.meshService = meshService;
            this.partitionRegistry = partitionRegistry;
            this.repositoryClient = repositoryClient;
            this.repositorySupplier = repositorySupplier;
            this.requestHelper = requestHelper;
        }

        public CommandResult call() {
            HashMap idByRpcId = new HashMap();
            HashMap<MeshNode, RpcBulkVerifyRepositoryIntegrityRequest.Builder> builderByNode = new HashMap<MeshNode, RpcBulkVerifyRepositoryIntegrityRequest.Builder>();
            RpcRepositoryLoader repositoryLoader = rpcId -> {
                Integer id = (Integer)idByRpcId.get(rpcId);
                return Optional.ofNullable(id == null ? null : this.repositorySupplier.getById(id.intValue()));
            };
            this.context.getRepositories().forEach(repository -> {
                long latestPullRequestId = this.context.getLatestPullRequestId(repository).orElse(0L);
                MeshNode node = this.selectNode((Repository)repository);
                if (node == null) {
                    log.warn("[{}] Cannot find a node that has a consistent replica of the repository. Skipping integrity checks", repository);
                    return;
                }
                RpcBulkVerifyRepositoryIntegrityRequest.Builder builder = builderByNode.computeIfAbsent(node, ignored -> RpcBulkVerifyRepositoryIntegrityRequest.newBuilder());
                String repositoryId = this.requestHelper.toRepositoryId(repository);
                idByRpcId.put(repositoryId, repository.getId());
                builder.addRepositoryRequests(RpcVerifyRepositoryRequest.newBuilder().setRepository(repositoryId).setLatestPullRequestId(latestPullRequestId));
                if (builder.getRepositoryRequestsCount() == 50) {
                    this.dispatchRequest(node, builder, repositoryLoader);
                    builderByNode.remove(node);
                    builder.getRepositoryRequestsList().forEach(repoDetails -> idByRpcId.remove(repoDetails.getRepository()));
                }
            });
            builderByNode.forEach((node, builder) -> this.dispatchRequest((MeshNode)node, (RpcBulkVerifyRepositoryIntegrityRequest.Builder)builder, repositoryLoader));
            return CommandResult.SUCCEEDED;
        }

        private void dispatchRequest(MeshNode node, RpcBulkVerifyRepositoryIntegrityRequest.Builder builder, RpcRepositoryLoader repositoryLoader) {
            log.debug("Dispatching request for checking integrity of {} repositories to {}", (Object)builder.getRepositoryRequestsCount(), (Object)node);
            this.repositoryClient.bulkVerifyRepositoryIntegrity(node, repositoryLoader, builder, this.callback);
        }

        private MeshNode selectNode(Repository repository) {
            if (repository.isLocal()) {
                return this.meshService.getSidecar().orElse(null);
            }
            int partition = repository.getPartition();
            return this.partitionRegistry.getPartition(partition).flatMap(p -> p.getReplicas().stream().map(MeshPartitionReplica::getNode).filter(node -> this.partitionRegistry.isConsistent(node, repository.getId())).findAny()).orElse(null);
        }
    }
}

