/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcAnyRepository;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcFetchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPrivateKeyCredentials;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRemoteRepository;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUsernamePasswordCredentials;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitMirrorCommandFactory;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncCallback;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncCommandParameters;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncContext;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncSummary;
import com.atlassian.bitbucket.scm.mirror.MirrorUpdateRefsCommandParameters;
import com.atlassian.stash.internal.scm.git.fetch.FetchCallback;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommand;
import com.atlassian.stash.internal.scm.git.mesh.MeshMirrorUpdateRefsCommand;
import com.atlassian.stash.internal.scm.git.mesh.RpcRefClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import com.google.common.io.Files;
import com.google.protobuf.ByteString;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class MeshGitMirrorCommandFactory
implements GitMirrorCommandFactory {
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RpcRefClient refClient;
    private final RpcRepositoryClient repositoryClient;

    public MeshGitMirrorCommandFactory(ExecutorService executorService, I18nService i18nService, RpcRefClient refClient, RpcRepositoryClient repositoryClient) {
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.refClient = refClient;
        this.repositoryClient = repositoryClient;
    }

    @Nonnull
    public GitCommand<Void> synchronize(final @Nonnull Repository repository, @Nonnull MirrorSyncCommandParameters parameters, final @Nonnull MirrorSyncCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        RpcRemoteRepository.Builder remoteRepository = RpcRemoteRepository.newBuilder().setUrl(parameters.getRemoteUrl());
        MeshGitMirrorCommandFactory.setCredentials(remoteRepository, parameters);
        final RpcFetchRequest.Builder fetchRequest = RpcFetchRequest.newBuilder().setAtomic(parameters.isAtomic()).setNoTags(!parameters.isWithTags()).setOptions(RpcGitOptions.newBuilder().putAllEnvironment(ByteStringUtils.toByteStringsLazily((Map)parameters.getEnvironment()))).setPrune(parameters.isPrune()).setSourceRepository(RpcAnyRepository.newBuilder().setRemoteRepository(remoteRepository).build()).addAllRefspecs(ByteStringUtils.toByteStringsLazily(MeshGitMirrorCommandFactory.getRefspecsOrDefaultToAll(parameters)));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcFetchRequest.Builder)fetchRequest).setTimeouts(arg_0));
                MeshGitMirrorCommandFactory.this.repositoryClient.fetch(repository, fetchRequest, (FetchCallback)new MirrorFetchCallback(callback));
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> updateRefs(@Nonnull Repository repository, @Nonnull MirrorUpdateRefsCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        return new MeshMirrorUpdateRefsCommand(this.executorService, this.i18nService, parameters, this.refClient, repository);
    }

    private static Collection<String> getRefspecsOrDefaultToAll(MirrorSyncCommandParameters parameters) {
        Set refspecs = parameters.getRefspecs();
        if (refspecs.isEmpty()) {
            return parameters.isIncludePrivateRefs() ? Collections.singleton("+refs/*:refs/*") : Arrays.asList("+refs/heads/*:refs/heads/*", "+refs/tags/*:refs/tags/*");
        }
        return refspecs;
    }

    private static void setCredentials(RpcRemoteRepository.Builder remoteRepository, MirrorSyncCommandParameters parameters) {
        if (parameters.isAnonymous()) {
            return;
        }
        if (parameters.getPrivateKey().isPresent()) {
            File keyFile = (File)parameters.getPrivateKey().get();
            try {
                byte[] keyBytes = Files.toByteArray((File)((File)parameters.getPrivateKey().get()));
                RpcPrivateKeyCredentials.Builder builder = RpcPrivateKeyCredentials.newBuilder().setPrivateKey(ByteString.copyFrom((byte[])keyBytes));
                parameters.getPassword().ifPresent(password -> builder.setPassword(ByteString.copyFromUtf8((String)password)));
                parameters.getUsername().ifPresent(username -> builder.setUsername(ByteString.copyFromUtf8((String)username)));
                remoteRepository.setPrivateKey(builder);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                throw new IllegalArgumentException("Private key file " + String.valueOf(keyFile) + " not found");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Private key file " + String.valueOf(keyFile) + " could not be read", e);
            }
        } else {
            RpcUsernamePasswordCredentials.Builder builder = RpcUsernamePasswordCredentials.newBuilder();
            parameters.getPassword().ifPresent(password -> builder.setPassword(ByteString.copyFromUtf8((String)password)));
            parameters.getUsername().ifPresent(username -> builder.setUsername(ByteString.copyFromUtf8((String)username)));
            remoteRepository.setUsernamePassword(builder.build());
        }
    }

    private static class MirrorFetchCallback
    implements FetchCallback {
        private final MirrorSyncCallback delegate;

        private MirrorFetchCallback(MirrorSyncCallback delegate) {
            this.delegate = delegate;
        }

        public void onEnd(@Nonnull CommandResult result) throws IOException {
            this.delegate.onEnd(new MirrorSyncSummary.Builder(result).build());
        }

        public boolean onFailedRef(@Nonnull MinimalRef ref) throws IOException {
            return this.delegate.onFailedRef(ref);
        }

        public boolean onRefChange(@Nonnull RefChange refChange) throws IOException {
            return this.delegate.onRefChange(refChange);
        }

        public void onStart() throws IOException {
            this.delegate.onStart(new MirrorSyncContext.Builder().build());
        }
    }
}

