/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangeContext;
import com.atlassian.bitbucket.content.Conflict;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcAcceptMergePullRequestRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBatchRescopePullRequestRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestChangesRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestCommitsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestDiffParsedRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestDiffStatsSummaryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergePullRequestRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPrepareMergePullRequestRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListOrder;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeResult;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractDiffCommandParameters;
import com.atlassian.bitbucket.scm.AbstractDiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitPullRequestCommandFactory;
import com.atlassian.bitbucket.scm.pull.BulkRescopeCommandParameters;
import com.atlassian.bitbucket.scm.pull.BulkRescopeContext;
import com.atlassian.bitbucket.scm.pull.PullRequestAcceptMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestChangesCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestCommitsCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDeleteCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDiffCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.scm.pull.PullRequestMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestPrepareMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.UpdatePullRequestRefsCommandParameters;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.stash.internal.scm.git.AuthorNameType;
import com.atlassian.stash.internal.scm.git.GitRepositoryConfig;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.SimpleGitCommand;
import com.atlassian.stash.internal.scm.git.command.diff.ConflictDecoratingChangeCallback;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommand;
import com.atlassian.stash.internal.scm.git.mesh.RpcPullRequestClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.pull.PullRequestMergeType;
import com.atlassian.stash.internal.scm.git.pull.PullRequestRefHelper;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public class MeshGitPullRequestCommandFactory
implements GitPullRequestCommandFactory {
    private final GitScmConfig config;
    private final ExecutorService executorService;
    private final RpcPullRequestClient pullRequestClient;
    private final PullRequestRefHelper refHelper;
    private final GitRepositoryConfig repositoryConfig;

    public MeshGitPullRequestCommandFactory(GitScmConfig config, ExecutorService executorService, RpcPullRequestClient pullRequestClient, PullRequestRefHelper refHelper, GitRepositoryConfig repositoryConfig) {
        this.config = config;
        this.executorService = executorService;
        this.pullRequestClient = pullRequestClient;
        this.refHelper = refHelper;
        this.repositoryConfig = repositoryConfig;
    }

    @Nonnull
    public GitCommand<Branch> acceptMerge(final @Nonnull PullRequest pullRequest, final @Nonnull PullRequestAcceptMergeCommandParameters parameters) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(parameters, "parameters");
        return new MeshGitCommand<Branch>(this.executorService){

            public Branch call() {
                RpcAcceptMergePullRequestRequest.Builder request = RpcAcceptMergePullRequestRequest.newBuilder();
                request.setCommitId(parameters.getMergeCommitHash());
                request.setExpectedTargetCommitId(parameters.getExpectedTargetCommitHash());
                return MeshGitPullRequestCommandFactory.this.pullRequestClient.acceptMerge(pullRequest, request);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> bulkRescope(final @Nonnull BulkRescopeCommandParameters parameters) {
        Objects.requireNonNull(parameters, "parameters");
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                BulkRescopeContext context = parameters.getRescopeContext();
                RpcBatchRescopePullRequestRequest.Builder request = RpcBatchRescopePullRequestRequest.newBuilder().setMaxCommitsPerUpdate(context.getMaxCommitIds()).setMaxMessageLength(MeshGitPullRequestCommandFactory.this.config.getMaxMessageLength());
                this.applyTimeouts(arg_0 -> ((RpcBatchRescopePullRequestRequest.Builder)request).setTimeouts(arg_0));
                MeshGitPullRequestCommandFactory.this.pullRequestClient.batchRescope(parameters.getRepository(), context, request);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> changes(final @Nonnull PullRequest pullRequest, @Nonnull PullRequestChangesCommandParameters parameters, final @Nonnull ChangeCallback callback) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        PullRequestEffectiveDiff effectiveDiff = this.refHelper.effectiveDiff(pullRequest);
        final ChangeContext context = parameters.toContext(effectiveDiff);
        final Map<String, Conflict> conflicts = this.refHelper.mapConflicts(pullRequest);
        final RpcGetPullRequestChangesRequest.Builder requestBuilder = RpcGetPullRequestChangesRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getPaths())).setAllowUnrelated(true).setDiffOptions(this.repositoryConfig.getDiffStrategy(pullRequest.getToRef().getRepository()).apply(RpcDiffOptions.newBuilder())).setLimit(parameters.getMaxChanges());
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcGetPullRequestChangesRequest.Builder)requestBuilder).setTimeouts(arg_0));
                MeshGitPullRequestCommandFactory.this.pullRequestClient.getChanges(pullRequest, requestBuilder, ConflictDecoratingChangeCallback.maybeWrap(callback, conflicts), context);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> commits(final @Nonnull PullRequest pullRequest, @Nonnull PullRequestCommitsCommandParameters parameters, final @Nonnull CommitCallback callback) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        final RpcGetPullRequestCommitsRequest.Builder requestBuilder = RpcGetPullRequestCommitsRequest.newBuilder().setOrder(RpcRevListOrder.ORDER_TOPOLOGICAL);
        if (parameters.getMaxMessageLength() >= 0) {
            requestBuilder.setMaxMessageLength(parameters.getMaxMessageLength());
        }
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcGetPullRequestCommitsRequest.Builder)requestBuilder).setTimeouts(arg_0));
                MeshGitPullRequestCommandFactory.this.pullRequestClient.getCommits(pullRequest, requestBuilder, callback);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> delete(@Nonnull PullRequest pullRequest, @Nonnull PullRequestDeleteCommandParameters parameters) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(parameters, "parameters");
        return this.delete(pullRequest.getToRef().getRepository(), pullRequest.getId(), parameters);
    }

    @Nonnull
    public GitCommand<Void> delete(final @Nonnull Repository repository, final long pullRequestId, @Nonnull PullRequestDeleteCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        return new SimpleGitCommand<Void>(this.executorService){

            public Void call() {
                MeshGitPullRequestCommandFactory.this.refHelper.deleteRefs(repository, pullRequestId);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> diff(final @Nonnull PullRequest pullRequest, @Nonnull PullRequestDiffCommandParameters parameters, final @Nonnull DiffContentCallback callback) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(callback, "callback");
        PullRequestEffectiveDiff effectiveDiff = this.refHelper.effectiveDiff(pullRequest);
        final DiffContext context = parameters.toContext(effectiveDiff);
        final RpcGetPullRequestDiffParsedRequest.Builder requestBuilder = RpcGetPullRequestDiffParsedRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getPaths())).setAllowUnrelated(true).setDiffOptions(this.repositoryConfig.getDiffStrategy(pullRequest.getToRef().getRepository()).apply(RpcUtils.prepareDiffOptions((AbstractDiffCommandParameters)parameters)));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcGetPullRequestDiffParsedRequest.Builder)requestBuilder).setTimeouts(arg_0));
                MeshGitPullRequestCommandFactory.this.pullRequestClient.getDiff(pullRequest, requestBuilder, callback, context);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<DiffStatsSummary> diffStatsSummary(final @Nonnull PullRequest pullRequest, @Nonnull PullRequestDiffStatsSummaryCommandParameters parameters) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(parameters, "parameters");
        final RpcGetPullRequestDiffStatsSummaryRequest.Builder requestBuilder = RpcGetPullRequestDiffStatsSummaryRequest.newBuilder().addAllPaths(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getPaths())).setAllowUnrelated(true).setDiffOptions(this.repositoryConfig.getDiffStrategy(pullRequest.getToRef().getRepository()).apply(RpcUtils.prepareDiffOptions((AbstractDiffStatsSummaryCommandParameters)parameters)));
        return new MeshGitCommand<DiffStatsSummary>(this.executorService){

            public DiffStatsSummary call() {
                this.applyTimeouts(arg_0 -> ((RpcGetPullRequestDiffStatsSummaryRequest.Builder)requestBuilder).setTimeouts(arg_0));
                return MeshGitPullRequestCommandFactory.this.pullRequestClient.getDiffStatsSummary(pullRequest, requestBuilder);
            }
        };
    }

    @Nonnull
    public GitCommand<PullRequestEffectiveDiff> effectiveDiff(final @Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        return new SimpleGitCommand<PullRequestEffectiveDiff>(this.executorService){

            public PullRequestEffectiveDiff call() {
                return MeshGitPullRequestCommandFactory.this.refHelper.effectiveDiff(pullRequest);
            }
        };
    }

    @Nonnull
    public GitCommand<Branch> merge(final @Nonnull PullRequest pullRequest, final @Nonnull PullRequestMergeCommandParameters parameters) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(parameters, "parameters");
        AuthorNameType nameType = this.repositoryConfig.getAuthorNameType(pullRequest.getToRef().getRepository());
        final RpcMergePullRequestRequest.Builder builder = RpcMergePullRequestRequest.newBuilder().setAllowUnrelated(true).setAuthor(RpcUtils.toPerson((Person)nameType.convert((Person)parameters.getAuthor()))).setCommitter(RpcUtils.toPerson((Person)nameType.convert((Person)parameters.getCommitter()))).setLog(parameters.getCommitSummaries()).setMaxMessageLength(this.config.getMaxMessageLength()).setMessage(ByteStringUtils.nullToEmpty((String)parameters.getMessage()));
        return new MeshGitCommand<Branch>(this.executorService){

            public Branch call() {
                this.applyTimeouts(arg_0 -> ((RpcMergePullRequestRequest.Builder)builder).setTimeouts(arg_0));
                if (parameters.isDryRun()) {
                    MeshGitPullRequestCommandFactory.this.pullRequestClient.tryMerge(pullRequest, builder, parameters.getStrategyId());
                    return null;
                }
                return MeshGitPullRequestCommandFactory.this.pullRequestClient.merge(pullRequest, builder, parameters.getStrategyId(), parameters.isAutoMerge());
            }
        };
    }

    @Nonnull
    public GitCommand<Branch> prepareMerge(final @Nonnull PullRequest pullRequest, final @Nonnull PullRequestPrepareMergeCommandParameters parameters) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(parameters, "parameters");
        return new MeshGitCommand<Branch>(this.executorService){

            public Branch call() {
                RpcPrepareMergePullRequestRequest.Builder requestBuilder = RpcPrepareMergePullRequestRequest.newBuilder().setMergeRequest(RpcMergePullRequestRequest.newBuilder().setAllowUnrelated(true).setAuthor(RpcUtils.toPerson((Person)parameters.getAuthor())).setCommitter(RpcUtils.toPerson((Person)parameters.getCommitter())).setLog(parameters.getCommitSummaries()).setMaxMessageLength(MeshGitPullRequestCommandFactory.this.config.getMaxMessageLength()).setMessage(ByteStringUtils.nullToEmpty((String)parameters.getMessage()))).setTemporaryBranchName(parameters.getTemporaryBranchName());
                return MeshGitPullRequestCommandFactory.this.pullRequestClient.prepareMerge(pullRequest, requestBuilder, parameters.getStrategyId());
            }
        };
    }

    @Nonnull
    public GitCommand<PullRequestMergeResult> tryMerge(final @Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        return new SimpleGitCommand<PullRequestMergeResult>(this.executorService){

            @Nonnull
            public PullRequestMergeResult call() {
                PullRequestMergeType mergeType = MeshGitPullRequestCommandFactory.this.refHelper.tryMerge(pullRequest);
                return new PullRequestMergeResult.Builder(mergeType.toOutcome()).build();
            }
        };
    }

    @Nonnull
    public GitCommand<Void> updateRefs(final @Nonnull UpdatePullRequestRefsCommandParameters parameters) {
        Objects.requireNonNull(parameters, "parameters");
        return new SimpleGitCommand<Void>(this.executorService){

            public Void call() {
                MeshGitPullRequestCommandFactory.this.refHelper.updateRefs(parameters.getPullRequests());
                return null;
            }
        };
    }
}

