/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.NoSuchObjectException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCheckFormatRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateBranchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateTagRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDeleteBranchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDeleteTagRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveAnnotatedTagRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTagType;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.InvalidAuthorException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitRefCommandFactory;
import com.atlassian.bitbucket.scm.git.ref.GitAnnotatedTagCallback;
import com.atlassian.bitbucket.scm.git.ref.GitCreateBranchCommandParameters;
import com.atlassian.bitbucket.scm.git.ref.GitCreateTagCommandParameters;
import com.atlassian.bitbucket.scm.git.ref.GitDeleteBranchCommandParameters;
import com.atlassian.bitbucket.scm.git.ref.GitDeleteTagCommandParameters;
import com.atlassian.bitbucket.scm.git.ref.GitResolveAnnotatedTagsCommandParameters;
import com.atlassian.bitbucket.scm.git.ref.GitValidateRefCommandParameters;
import com.atlassian.bitbucket.scm.ref.AbstractRefCommandParameters;
import com.atlassian.bitbucket.scm.ref.CreateBranchCommandParameters;
import com.atlassian.bitbucket.scm.ref.CreateTagCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.SimplePerson;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.scm.git.GitRepositoryConfig;
import com.atlassian.stash.internal.scm.git.InternalGitConstants;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommand;
import com.atlassian.stash.internal.scm.git.mesh.RpcRefClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.google.protobuf.ByteString;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;

public class MeshGitRefCommandFactory
implements GitRefCommandFactory {
    private final AuthenticationContext authenticationContext;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RpcRefClient refClient;
    private final GitRepositoryConfig repositoryConfig;

    public MeshGitRefCommandFactory(AuthenticationContext authenticationContext, ExecutorService executorService, I18nService i18nService, RpcRefClient refClient, GitRepositoryConfig repositoryConfig) {
        this.authenticationContext = authenticationContext;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.refClient = refClient;
        this.repositoryConfig = repositoryConfig;
    }

    @Nonnull
    public GitCommand<Branch> createBranch(final @Nonnull Repository repository, @Nonnull CreateBranchCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        String startPoint = Objects.requireNonNull(parameters.getStartPoint(), "startPoint");
        if (startPoint.trim().startsWith("-")) {
            throw new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branch.pointinvalid", new Object[]{startPoint}), startPoint);
        }
        Person author = this.chooseAuthor(repository, (AbstractRefCommandParameters)parameters);
        if (author == null) {
            throw new InvalidAuthorException(this.i18nService.createKeyedMessage("bitbucket.git.branch.create.anonymousnotallowed", new Object[0]));
        }
        final RpcCreateBranchRequest.Builder builder = RpcCreateBranchRequest.newBuilder().setName(ByteString.copyFromUtf8((String)parameters.getName())).setAuthor(RpcUtils.toPerson((Person)author)).setStartPoint(ByteString.copyFromUtf8((String)startPoint));
        if (parameters instanceof GitCreateBranchCommandParameters) {
            GitCreateBranchCommandParameters gitParameters = (GitCreateBranchCommandParameters)parameters;
            builder.setForce(gitParameters.isForce()).setReflog(gitParameters.isReflog());
        }
        return new MeshGitCommand<Branch>(this.executorService){

            public Branch call() {
                this.applyTimeouts(arg_0 -> ((RpcCreateBranchRequest.Builder)builder).setTimeouts(arg_0));
                return MeshGitRefCommandFactory.this.refClient.createBranch(repository, builder);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> resolveAnnotatedTags(final @Nonnull Repository repository, @Nonnull GitResolveAnnotatedTagsCommandParameters parameters, final @Nonnull GitAnnotatedTagCallback callback) {
        final RpcResolveAnnotatedTagRequest.Builder request = RpcResolveAnnotatedTagRequest.newBuilder().addAllTagIds(ByteStringUtils.toByteStringsLazily((Iterable)parameters.getTagIds())).setMaxMessageLength(parameters.getMaxMessageLength());
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcResolveAnnotatedTagRequest.Builder)request).setTimeouts(arg_0));
                MeshGitRefCommandFactory.this.refClient.resolveAnnotatedTags(repository, request, callback);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Tag> createTag(final @Nonnull Repository repository, @Nonnull CreateTagCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        String startPoint = Objects.requireNonNull(parameters.getStartPoint(), "startPoint");
        if (startPoint.trim().startsWith("-")) {
            throw new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.service.repository.tag.startpointinvalid", new Object[]{startPoint}), startPoint);
        }
        Person author = this.chooseAuthor(repository, (AbstractRefCommandParameters)parameters);
        if (author == null) {
            throw new InvalidAuthorException(this.i18nService.createKeyedMessage("bitbucket.git.tag.create.anonymousnotallowed", new Object[0]));
        }
        final RpcCreateTagRequest.Builder builder = RpcCreateTagRequest.newBuilder().setName(ByteString.copyFromUtf8((String)parameters.getName())).setMessage(ByteStringUtils.nullToEmpty((String)parameters.getMessage())).setAuthor(RpcUtils.toPerson((Person)author)).setStartPoint(ByteString.copyFromUtf8((String)startPoint));
        if (parameters instanceof GitCreateTagCommandParameters) {
            GitCreateTagCommandParameters gitParameters = (GitCreateTagCommandParameters)parameters;
            builder.setForce(gitParameters.isForce()).setType(this.mapTagType(gitParameters));
        }
        return new MeshGitCommand<Tag>(this.executorService){

            public Tag call() {
                this.applyTimeouts(arg_0 -> ((RpcCreateTagRequest.Builder)builder).setTimeouts(arg_0));
                return MeshGitRefCommandFactory.this.refClient.createTag(repository, builder);
            }
        };
    }

    @Nonnull
    public GitCommand<Void> deleteBranch(final @Nonnull Repository repository, @Nonnull GitDeleteBranchCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Person author = this.chooseAuthor(repository, (AbstractRefCommandParameters)parameters);
        if (author == null) {
            throw new InvalidAuthorException(this.i18nService.createKeyedMessage("bitbucket.git.branch.delete.anonymousnotallowed", new Object[0]));
        }
        final RpcDeleteBranchRequest.Builder builder = RpcDeleteBranchRequest.newBuilder().setAuthor(RpcUtils.toPerson((Person)author)).setForce(parameters.isForce()).setName(ByteString.copyFromUtf8((String)parameters.getName()));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcDeleteBranchRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitRefCommandFactory.this.refClient.deleteBranch(repository, builder);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> deleteTag(final @Nonnull Repository repository, @Nonnull GitDeleteTagCommandParameters parameters) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(parameters, "parameters");
        Person author = this.chooseAuthor(repository, (AbstractRefCommandParameters)parameters);
        if (author == null) {
            throw new InvalidAuthorException(this.i18nService.createKeyedMessage("bitbucket.git.branch.delete.anonymousnotallowed", new Object[0]));
        }
        final RpcDeleteTagRequest.Builder builder = RpcDeleteTagRequest.newBuilder().setName(ByteString.copyFromUtf8((String)parameters.getName())).setAuthor(RpcUtils.toPerson((Person)author));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcDeleteTagRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitRefCommandFactory.this.refClient.deleteTag(repository, builder);
                return null;
            }
        };
    }

    @Nonnull
    public GitCommand<Void> validateRef(@Nonnull GitValidateRefCommandParameters parameters) {
        Objects.requireNonNull(parameters, "parameters");
        final RpcCheckFormatRequest.Builder builder = RpcCheckFormatRequest.newBuilder().setRefId(ByteString.copyFromUtf8((String)parameters.getName()));
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                this.applyTimeouts(arg_0 -> ((RpcCheckFormatRequest.Builder)builder).setTimeouts(arg_0));
                MeshGitRefCommandFactory.this.refClient.checkFormat(builder);
                return null;
            }
        };
    }

    private Person chooseAuthor(Repository repository, AbstractRefCommandParameters parameters) {
        ApplicationUser author = parameters.getAuthor();
        if (author == null && (author = this.authenticationContext.getCurrentUser()) == null) {
            return null;
        }
        author = this.repositoryConfig.getAuthorNameType(repository).convert((Person)author);
        return new SimplePerson((String)StringUtils.defaultIfBlank((CharSequence)author.getName(), (CharSequence)InternalGitConstants.SYSTEM_DISPLAY_NAME), (String)StringUtils.defaultIfBlank((CharSequence)author.getEmailAddress(), (CharSequence)InternalGitConstants.SYSTEM_EMAIL_ADDRESS));
    }

    private RpcTagType mapTagType(GitCreateTagCommandParameters parameters) {
        switch (parameters.getType()) {
            case ANNOTATED: {
                return RpcTagType.TAG_ANNOTATED;
            }
            case LIGHTWEIGHT: {
                return RpcTagType.TAG_LIGHTWEIGHT;
            }
        }
        throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.tag.unexpected.type", new Object[]{parameters.getType()}));
    }
}

