/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.event.project.ProjectModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetMetadataRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshGitRepositoryConfigListener {
    private static final Logger log = LoggerFactory.getLogger(MeshGitRepositoryConfigListener.class);
    private final ScheduledExecutorService executorService;
    private final RpcRepositoryClient repositoryClient;
    private final Predicate<Repository> repositoryFilter;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;

    public MeshGitRepositoryConfigListener(ScheduledExecutorService executorService, RpcRepositoryClient repositoryClient, RepositoryService repositoryService, SecurityService securityService, boolean sidecarEnabled) {
        this.executorService = executorService;
        this.repositoryClient = repositoryClient;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.repositoryFilter = sidecarEnabled ? repository -> "git".equals(repository.getScmId()) : repository -> repository.isRemote() && "git".equals(repository.getScmId());
    }

    @EventListener
    public void onProjectModified(ProjectModifiedEvent event) {
        Project newProject = event.getNewValue();
        Project oldProject = event.getOldValue();
        if (!newProject.getKey().equals(oldProject.getKey())) {
            this.executorService.schedule(() -> this.updateRepositories(newProject), 15L, TimeUnit.SECONDS);
        }
    }

    @EventListener
    public void onRepositoryModified(RepositoryModifiedEvent event) {
        Repository newRepository = event.getNewValue();
        if (this.repositoryFilter.test(newRepository)) {
            Repository oldRepository = event.getOldValue();
            if (!newRepository.getSlug().equals(oldRepository.getSlug()) || newRepository.getProject().getId() != oldRepository.getProject().getId()) {
                this.executorService.schedule(() -> this.update(newRepository), 15L, TimeUnit.SECONDS);
            }
        }
    }

    private Page<Repository> findRepositoriesByProject(Project project, PageRequest pageRequest) {
        return this.repositoryService.findByProjectKey(project.getKey(), pageRequest);
    }

    private void updateRepositories(Project project) {
        this.securityService.withPermission(Permission.PROJECT_READ, (Object)project, "Updating repository-config").call(() -> {
            PageUtils.toStream(pageRequest -> this.findRepositoriesByProject(project, pageRequest), (int)100).filter(this.repositoryFilter).forEach(this::update);
            return null;
        });
    }

    private void update(Repository repository) {
        try {
            RpcSetMetadataRequest.Builder builder = RpcSetMetadataRequest.newBuilder().putMetadata("hierarchy", repository.getHierarchyId()).putMetadata("project", repository.getProject().getKey()).putMetadata("repository", repository.getSlug());
            this.repositoryClient.setMetadata(repository, builder);
        }
        catch (Exception e) {
            log.warn("{}: Repository metadata could not be updated", (Object)repository, (Object)e);
        }
    }
}

