/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.ScmStatus;
import com.atlassian.bitbucket.scm.SimpleScmStatus;
import com.atlassian.bitbucket.scm.git.GitIntegrityCheckCommandFactory;
import com.atlassian.bitbucket.scm.git.GitWorkTreeBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitBulkContentCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitCompareCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitExtendedCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitMirrorCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitPullRequestCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitRefCommandFactory;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.stash.internal.scm.git.DefaultGitScm;
import com.atlassian.stash.internal.scm.git.GitHookHandlerFactory;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.GitWriteTracker;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import com.atlassian.stash.internal.scm.git.mesh.SidecarManager;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshGitScm
extends DefaultGitScm {
    private static final Logger log = LoggerFactory.getLogger(MeshGitScm.class);
    private final RpcRepositoryClient repositoryClient;
    private final SidecarManager sidecarManager;

    public MeshGitScm(GitCommandBuilderFactory builderFactory, GitBulkContentCommandFactory bulkContentCommandFactory, GitCommandFactory commandFactory, GitCompareCommandFactory compareCommandFactory, GitScmConfig config, GitExtendedCommandFactory extendedCommandFactory, FeatureManager featureManager, GitHookHandlerFactory hookHandlerFactory, I18nService i18nService, GitIntegrityCheckCommandFactory integrityCheckCommandFactory, GitMirrorCommandFactory mirrorCommandFactory, GitPullRequestCommandFactory pullRequestCommandFactory, GitRefCommandFactory refCommandFactory, RpcRepositoryClient repositoryClient, SidecarManager sidecarManager, GitWorkTreeBuilderFactory workTreeBuilderFactory, GitWriteTracker writeTracker) {
        super(null, builderFactory, bulkContentCommandFactory, commandFactory, compareCommandFactory, config, extendedCommandFactory, featureManager, hookHandlerFactory, i18nService, integrityCheckCommandFactory, mirrorCommandFactory, pullRequestCommandFactory, refCommandFactory, workTreeBuilderFactory, writeTracker);
        this.repositoryClient = repositoryClient;
        this.sidecarManager = sidecarManager;
    }

    @Override
    @Nonnull
    public MinimalRef getDefaultBranch(@Nonnull Repository repository) {
        return this.repositoryClient.getDefaultBranch(repository);
    }

    @Nonnull
    public Set<ScmFeature> getFeatures() {
        return new ImmutableSet.Builder().addAll((Iterable)super.getFeatures()).add((Object)ScmFeature.REVERT).build();
    }

    @Override
    @Nonnull
    public ScmStatus getStatus() {
        if (this.sidecarManager.isStarted()) {
            return this.sidecarManager.isAlive() && this.sidecarManager.isReady() ? super.getStatus() : SimpleScmStatus.unavailable((KeyedMessage)this.i18nService.createKeyedMessage("bitbucket.git.mesh.sidecar.dead", new Object[0]));
        }
        return super.getStatus();
    }

    @Override
    public boolean isEmpty(@Nonnull Repository repository) {
        return this.repositoryClient.isEmpty(repository);
    }
}

