/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryPushHookRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.migration.HierarchyMigrationState;
import com.atlassian.bitbucket.mesh.migration.MigrationStateManager;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshMigrationHook
implements PreRepositoryHook<RepositoryPushHookRequest> {
    @VisibleForTesting
    static final String KEY_REF_UPDATE_REJECTED = "bitbucket.git.mesh.migration.repository.migrated";
    @VisibleForTesting
    static final String KEY_REF_UPDATE_REJECTED_DETAIL = "bitbucket.git.mesh.migration.repository.migrated.detail";
    private static final Logger log = LoggerFactory.getLogger(MeshMigrationHook.class);
    private final I18nService i18nService;
    private final MigrationStateManager migrationStateManager;

    public MeshMigrationHook(I18nService i18nService, MigrationStateManager migrationStateManager) {
        this.i18nService = i18nService;
        this.migrationStateManager = migrationStateManager;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull RepositoryPushHookRequest request) {
        Repository repository = request.getRepository();
        if (repository.isLocal() && this.isMigrationComplete(repository)) {
            log.info("[{}] Rejecting ref-update because the repository has been migrated", (Object)repository);
            return RepositoryHookResult.rejected((String)this.i18nService.getMessage(KEY_REF_UPDATE_REJECTED, new Object[0]), (String)this.i18nService.getMessage(KEY_REF_UPDATE_REJECTED_DETAIL, new Object[0]));
        }
        return RepositoryHookResult.accepted();
    }

    private boolean isMigrationComplete(Repository repository) {
        return this.migrationStateManager.getForHierarchy(repository.getHierarchyId()).map(HierarchyMigrationState::isCompleted).orElse(false);
    }
}

