/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUpdateRefsRequest;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.mirror.MirrorUpdateRefsCommandFailedException;
import com.atlassian.bitbucket.scm.mirror.MirrorUpdateRefsCommandParameters;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommand;
import com.atlassian.stash.internal.scm.git.mesh.RpcRefClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshMirrorUpdateRefsCommand
extends MeshGitCommand<Void> {
    private static final Logger log = LoggerFactory.getLogger(MeshMirrorUpdateRefsCommand.class);
    private final I18nService i18nService;
    private final MirrorUpdateRefsCommandParameters parameters;
    private final RpcRefClient refClient;
    private final Repository repository;

    public MeshMirrorUpdateRefsCommand(@Nonnull ExecutorService executorService, @Nonnull I18nService i18nService, @Nonnull MirrorUpdateRefsCommandParameters parameters, @Nonnull RpcRefClient refClient, @Nonnull Repository repository) {
        super(executorService);
        this.i18nService = i18nService;
        this.parameters = parameters;
        this.refClient = refClient;
        this.repository = repository;
    }

    public Void call() {
        List failed;
        RpcUpdateRefsRequest.Builder builder = RpcUpdateRefsRequest.newBuilder().setTransactional(false);
        this.applyTimeouts(arg_0 -> ((RpcUpdateRefsRequest.Builder)builder).setTimeouts(arg_0));
        HashMap<String, RefChange> changesById = new HashMap<String, RefChange>();
        for (RefChange refChange2 : this.parameters.getChanges()) {
            builder.addRefUpdates(RpcUtils.toProposedRefUpdate((RefChange)refChange2));
            changesById.put(refChange2.getRef().getId(), refChange2);
        }
        try {
            List failedRefs = this.refClient.updateRefs(this.repository, builder);
            if (failedRefs.isEmpty()) {
                failed = Collections.emptyList();
            } else {
                failed = new ArrayList(failedRefs.size());
                for (MinimalRef failedRef : failedRefs) {
                    RefChange refChange3 = (RefChange)changesById.get(failedRef.getId());
                    if (refChange3 == null) {
                        log.warn("{}: Unexpected failure updating {}; no update was requested", (Object)this.repository, (Object)failedRef.getId());
                        continue;
                    }
                    failed.add(refChange3);
                }
            }
        }
        catch (RuntimeException e) {
            failed = this.parameters.getChanges();
            log.warn("{}: Updating {} refs failed", new Object[]{this.repository, failed.size(), e});
        }
        if (failed.isEmpty()) {
            return null;
        }
        String failedIds = failed.stream().map(refChange -> refChange.getRef().getId()).collect(Collectors.joining(", "));
        throw new MirrorUpdateRefsCommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.ref.bulk.update.failed", new Object[]{this.repository, failedIds}), failed);
    }
}

