/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.concurrent.PullRequestLock;
import com.atlassian.bitbucket.content.Conflict;
import com.atlassian.bitbucket.dmz.server.DmzStorageService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitTimeouts;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergePullRequestRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.MergeException;
import com.atlassian.bitbucket.scm.git.command.merge.GitMergeException;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.GitMergeConflict;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.SimplePerson;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.GitTimers;
import com.atlassian.stash.internal.scm.git.InternalGitConstants;
import com.atlassian.stash.internal.scm.git.mesh.RpcPullRequestClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCache;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestSupplier;
import com.atlassian.stash.internal.scm.git.pull.MergeConflictNoteReader;
import com.atlassian.stash.internal.scm.git.pull.MergeConflictNoteWriter;
import com.atlassian.stash.internal.scm.git.pull.PullRequestMerge;
import com.atlassian.stash.internal.scm.git.pull.PullRequestMergeType;
import com.atlassian.stash.internal.scm.git.pull.PullRequestRefBuilder;
import com.atlassian.stash.internal.scm.git.pull.PullRequestRefHelper;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.base.Throwables;
import com.google.protobuf.ByteString;
import io.atlassian.util.concurrent.ConcurrentOperationMap;
import io.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshPullRequestRefHelper
implements PullRequestRefHelper {
    private static final Logger log = LoggerFactory.getLogger(MeshPullRequestRefHelper.class);
    private final AuthenticationContext authenticationContext;
    private final GitPullRequestCache cache;
    private final GitScmConfig config;
    private final ConcurrentOperationMap<PullRequestKey, PullRequestEffectiveDiff> effectiveDiffOperationMap;
    private final PullRequestLock lock;
    private final ConcurrentOperationMap<PullRequestKey, PullRequestMergeType> mergeTypeOperationMap;
    private final RpcPullRequestClient pullRequestClient;
    private final GitPullRequestSupplier pullRequestSupplier;
    private final DmzStorageService storageService;
    private final ConcurrentOperationMap<PullRequestKey, Long> updateRefsOperationMap;

    public MeshPullRequestRefHelper(AuthenticationContext authenticationContext, GitPullRequestCache cache, GitScmConfig config, PullRequestLock lock, RpcPullRequestClient pullRequestClient, GitPullRequestSupplier pullRequestSupplier, DmzStorageService storageService) {
        this.authenticationContext = authenticationContext;
        this.cache = cache;
        this.config = config;
        this.lock = lock;
        this.pullRequestClient = pullRequestClient;
        this.pullRequestSupplier = pullRequestSupplier;
        this.storageService = storageService;
        this.effectiveDiffOperationMap = new ConcurrentOperationMapImpl();
        this.mergeTypeOperationMap = new ConcurrentOperationMapImpl();
        this.updateRefsOperationMap = new ConcurrentOperationMapImpl();
    }

    @Override
    public void deleteRefs(@Nonnull Repository repository, long pullRequestId) {
        Objects.requireNonNull(repository, "repository");
        this.withLock(repository.getId(), pullRequestId, () -> {
            this.pullRequestClient.delete(repository, pullRequestId);
            return null;
        });
    }

    @Override
    @Nonnull
    public PullRequestEffectiveDiff effectiveDiff(@Nonnull PullRequest pullRequest) {
        EffectiveDiffOperation operation = new EffectiveDiffOperation();
        PullRequestEffectiveDiff cached = (PullRequestEffectiveDiff)operation.getCached(pullRequest, false);
        if (cached != null) {
            return cached;
        }
        try {
            return (PullRequestEffectiveDiff)this.effectiveDiffOperationMap.runOperation((Object)new PullRequestKey(pullRequest), new LockedOperation<PullRequestEffectiveDiff>(pullRequest, operation));
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException("Failed to resolve the effective diff for " + String.valueOf(pullRequest), e.getCause());
        }
    }

    @Override
    public Map<String, Conflict> mapConflicts(@Nonnull PullRequest pullRequest) {
        block11: {
            Map<String, Conflict> map;
            block10: {
                if (this.tryMerge(pullRequest) != PullRequestMergeType.CONFLICTED) {
                    return null;
                }
                Reader reader2 = this.openConflictNotes(pullRequest);
                try {
                    map = new MergeConflictNoteReader(reader2).readConflicts();
                    if (reader2 == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader2 != null) {
                            try {
                                reader2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException | NoSuchFileException reader2) {
                        break block11;
                    }
                    catch (Exception e) {
                        log.warn("{}:{}@{}: Failed to read conflict notes", new Object[]{pullRequest.getToRef().getRepository(), pullRequest.getId(), pullRequest.getVersion(), e});
                    }
                }
                reader2.close();
            }
            return map;
        }
        return null;
    }

    @Override
    @Nonnull
    public PullRequestMergeType tryMerge(@Nonnull PullRequest pullRequest) {
        TryMergeOperation operation = new TryMergeOperation();
        PullRequestMergeType cached = operation.getCached(pullRequest, false);
        if (cached != null) {
            return cached;
        }
        try {
            return (PullRequestMergeType)this.mergeTypeOperationMap.runOperation((Object)new PullRequestKey(pullRequest), new LockedOperation<PullRequestMergeType>(pullRequest, operation));
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException("Failed trying to merge " + String.valueOf(pullRequest), e.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateRefs(@Nonnull Collection<PullRequest> pullRequests) {
        try (Ticker ignored = Timers.start((String)"git: update refs");){
            for (PullRequest pullRequest : pullRequests) {
                try {
                    this.updateRefsOperationMap.runOperation((Object)new PullRequestKey(pullRequest), new LockedOperation<Long>(pullRequest, new UpdateRefsOperation()));
                }
                catch (ExecutionException e) {
                    Throwables.throwIfUnchecked((Throwable)e.getCause());
                    throw new RuntimeException("Failed trying to update refs for " + String.valueOf(pullRequest), e.getCause());
                    return;
                }
            }
        }
    }

    private static boolean isValidMergeAuthor(ApplicationUser user) {
        return user != null && StringUtils.isNotBlank((CharSequence)user.getEmailAddress()) && StringUtils.isNotBlank((CharSequence)user.getDisplayName());
    }

    private Person chooseAuthor(PullRequest pullRequest) {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (!MeshPullRequestRefHelper.isValidMergeAuthor(user)) {
            user = pullRequest.getAuthor().getUser();
        }
        return new SimplePerson((String)StringUtils.defaultIfBlank((CharSequence)user.getDisplayName(), (CharSequence)InternalGitConstants.SYSTEM_DISPLAY_NAME), (String)StringUtils.defaultIfBlank((CharSequence)user.getEmailAddress(), (CharSequence)InternalGitConstants.SYSTEM_EMAIL_ADDRESS));
    }

    private Path conflictNotesFile(PullRequest pullRequest) {
        return this.storageService.getHierarchyDataDir(pullRequest.getToRef().getRepository()).resolve("pull-requests").resolve(Long.toString(pullRequest.getId())).resolve("conflicts");
    }

    private void createConflictNotesDir(Path notesDir) {
        int i = 0;
        while (true) {
            try {
                MoreFiles.mkdir((Path)notesDir);
            }
            catch (IllegalStateException e) {
                if (i == 4) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    private void deleteConflicts(PullRequest pullRequest, Path notesFile) {
        try {
            Files.delete(notesFile);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException e) {
            log.warn("{}:{}@{} Failed to delete outdated conflict notes", new Object[]{pullRequest.getToRef().getRepository(), pullRequest.getId(), pullRequest.getVersion(), e});
        }
    }

    private Path legacyConflictNotesFile(PullRequest pullRequest) {
        return PullRequestRefBuilder.darkRef().id(pullRequest).name("notes").toPath(this.storageService.getRepositoryDir(pullRequest.getToRef().getRepository()));
    }

    private Reader openConflictNotes(PullRequest pullRequest) throws IOException {
        try {
            return Files.newBufferedReader(this.conflictNotesFile(pullRequest));
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            if (pullRequest.getToRef().getRepository().isLocal()) {
                try {
                    return Files.newBufferedReader(this.legacyConflictNotesFile(pullRequest));
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private void withLock(PullRequest pullRequest, UncheckedOperation<?> operation) {
        this.withLock(pullRequest.getToRef().getRepository().getId(), pullRequest.getId(), operation);
    }

    private <T> T withLock(int repositoryId, long pullRequestId, UncheckedOperation<T> operation) {
        try (Ticker ignored = Timers.timer((String)"git: with pull request lock").start(new Object[]{repositoryId, pullRequestId});){
            Object object = this.lock.withLock(repositoryId, pullRequestId, operation);
            return (T)object;
        }
    }

    private void writeConflicts(PullRequest pullRequest, List<GitMergeConflict> conflicts) {
        Path notesFile = this.conflictNotesFile(pullRequest);
        try {
            this.createConflictNotesDir(notesFile.getParent());
        }
        catch (IllegalStateException e) {
            log.warn("{}:{}@{} Failed to prepare conflict notes", new Object[]{pullRequest.getToRef().getRepository(), pullRequest.getId(), pullRequest.getVersion(), e});
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(notesFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            MergeConflictNoteWriter noteWriter = new MergeConflictNoteWriter(writer);
            noteWriter.writeBranches(pullRequest);
            for (GitMergeConflict conflict : conflicts) {
                noteWriter.writeConflict(conflict);
            }
        }
        catch (IOException e) {
            log.warn("{}:{}@{} Failed to write conflict notes", new Object[]{pullRequest.getToRef().getRepository(), pullRequest.getId(), pullRequest.getVersion(), e});
        }
    }

    @NotThreadSafe
    private class EffectiveDiffOperation
    implements PullRequestOperation<PullRequestEffectiveDiff> {
        private EffectiveDiffOperation() {
        }

        @Override
        public PullRequestEffectiveDiff getCached(@Nonnull PullRequest pullRequest, boolean locked) {
            String cachedAncestor = MeshPullRequestRefHelper.this.cache.getCommonAncestor(pullRequest);
            if (cachedAncestor == null) {
                return null;
            }
            return new PullRequestEffectiveDiff(pullRequest.getFromRef().getLatestCommit(), cachedAncestor);
        }

        @Override
        @Nonnull
        public PullRequestEffectiveDiff perform(@Nonnull PullRequest pullRequest) {
            PullRequestEffectiveDiff effectiveDiff;
            String idAtVersion = pullRequest.getId() + "@" + pullRequest.getVersion();
            try (Ticker ignored = GitTimers.RESOLVE_EFFECTIVE_DIFF.start(new String[]{idAtVersion});){
                effectiveDiff = MeshPullRequestRefHelper.this.pullRequestClient.getEffectiveDiff(pullRequest);
            }
            MeshPullRequestRefHelper.this.cache.putCommonAncestor(pullRequest, effectiveDiff.getSinceId());
            return effectiveDiff;
        }
    }

    private static interface PullRequestOperation<T> {
        @Nullable
        public T getCached(@Nonnull PullRequest var1, boolean var2);

        @Nonnull
        public T perform(@Nonnull PullRequest var1);
    }

    private static class PullRequestKey {
        private final long[] pieces;

        PullRequestKey(PullRequest pullRequest) {
            this.pieces = new long[]{pullRequest.getToRef().getRepository().getId(), pullRequest.getId(), pullRequest.getVersion()};
        }

        public boolean equals(Object o) {
            return o == this || o instanceof PullRequestKey && Arrays.equals(this.pieces, ((PullRequestKey)o).pieces);
        }

        public int hashCode() {
            return Arrays.hashCode(this.pieces);
        }
    }

    private class LockedOperation<T>
    implements Callable<T>,
    UncheckedOperation<T> {
        private final PullRequestOperation<T> operation;
        private final long pullRequestId;
        private final int repositoryId;

        LockedOperation(PullRequest pullRequest, PullRequestOperation<T> operation) {
            this.pullRequestId = pullRequest.getId();
            this.repositoryId = pullRequest.getToRef().getRepository().getId();
            this.operation = operation;
        }

        @Override
        public T call() {
            return MeshPullRequestRefHelper.this.withLock(this.repositoryId, this.pullRequestId, this);
        }

        public T perform() {
            PullRequest pullRequest = MeshPullRequestRefHelper.this.pullRequestSupplier.getById(this.repositoryId, this.pullRequestId);
            T cached = this.operation.getCached(pullRequest, true);
            if (cached != null) {
                return cached;
            }
            return this.operation.perform(pullRequest);
        }
    }

    @NotThreadSafe
    private class TryMergeOperation
    implements PullRequestOperation<PullRequestMergeType> {
        private TryMergeOperation() {
        }

        @Override
        public PullRequestMergeType getCached(@Nonnull PullRequest pullRequest, boolean locked) {
            return MeshPullRequestRefHelper.this.cache.getMergeType(pullRequest, locked);
        }

        @Override
        @Nonnull
        public PullRequestMergeType perform(@Nonnull PullRequest pullRequest) {
            PullRequestMerge merge;
            String idAtVersion = pullRequest.getId() + "@" + pullRequest.getVersion();
            try (Ticker ignored = GitTimers.TRY_MERGE.start(new String[]{idAtVersion});){
                merge = this.tryMerge(pullRequest, idAtVersion);
            }
            MeshPullRequestRefHelper.this.cache.putMergeType(pullRequest, merge.getType());
            if (pullRequest.getToRef().getRepository().isLocal()) {
                MeshPullRequestRefHelper.this.deleteConflicts(pullRequest, MeshPullRequestRefHelper.this.legacyConflictNotesFile(pullRequest));
            }
            if (merge.hasConflicts()) {
                MeshPullRequestRefHelper.this.writeConflicts(pullRequest, merge.getConflicts());
            } else {
                MeshPullRequestRefHelper.this.deleteConflicts(pullRequest, MeshPullRequestRefHelper.this.conflictNotesFile(pullRequest));
            }
            return merge.getType();
        }

        private void requestTryMerge(PullRequest pullRequest) {
            long timeout = MeshPullRequestRefHelper.this.config.getPullRequestOperationTimeout().getSeconds();
            MeshPullRequestRefHelper.this.pullRequestClient.tryMerge(pullRequest, RpcMergePullRequestRequest.newBuilder().setAllowUnrelated(true).setAuthor(RpcUtils.toPerson((Person)MeshPullRequestRefHelper.this.chooseAuthor(pullRequest))).setMessage(ByteString.copyFromUtf8((String)("Trial merge for pull request #" + pullRequest.getId() + "@" + pullRequest.getVersion()))).setTimeouts(RpcGitTimeouts.newBuilder().setExecution(timeout).setIdle(timeout)), null);
        }

        private PullRequestMerge tryMerge(PullRequest pullRequest, String idAtVersion) {
            Repository repository = pullRequest.getToRef().getRepository();
            try {
                log.trace("{}: Attempting to automatically merge pull request {}", (Object)repository, (Object)idAtVersion);
                this.requestTryMerge(pullRequest);
                log.debug("{}: Pull request {} merged automatically without conflicts", (Object)repository, (Object)idAtVersion);
                return new PullRequestMerge(PullRequestMergeType.CLEAN);
            }
            catch (RuntimeException e) {
                if (e instanceof MergeException && ((MergeException)e).isConflicted()) {
                    List conflicts = ((GitMergeException)e.getCause()).getConflicts();
                    log.info("{}: Pull request {} cannot be merged automatically due to conflicts in {} file(s)", new Object[]{repository, idAtVersion, conflicts.size()});
                    return new PullRequestMerge(PullRequestMergeType.CONFLICTED, conflicts);
                }
                if (log.isDebugEnabled()) {
                    log.info("{}: Pull request {} failed automatic merging", new Object[]{repository, idAtVersion, e});
                } else {
                    log.info("{}: Pull request {} failed automatic merging: {}", new Object[]{repository, idAtVersion, Throwables.getRootCause((Throwable)e).getMessage()});
                }
                return new PullRequestMerge(PullRequestMergeType.BASE);
            }
        }
    }

    private class UpdateRefsOperation
    implements PullRequestOperation<Long> {
        private UpdateRefsOperation() {
        }

        @Override
        public Long getCached(@Nonnull PullRequest pullRequest, boolean locked) {
            return null;
        }

        @Override
        @Nonnull
        public Long perform(@Nonnull PullRequest pullRequest) {
            MeshPullRequestRefHelper.this.pullRequestClient.updateRefs(pullRequest);
            return pullRequest.getId();
        }
    }
}

