/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.process.LinePump;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCatFileBatchRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.signed.SignableObjectType;
import com.atlassian.bitbucket.scm.signed.SignedObjectCallback;
import com.atlassian.bitbucket.scm.signed.SignedObjectIdSource;
import com.atlassian.bitbucket.scm.signed.SignedObjectsContext;
import com.atlassian.bitbucket.scm.signed.SignedObjectsParameters;
import com.atlassian.bitbucket.scm.signed.SignedObjectsSummary;
import com.atlassian.bitbucket.scm.signed.StandardSignableObjectType;
import com.atlassian.bitbucket.util.AbstractSummary;
import com.atlassian.stash.internal.scm.git.command.SimpleGitCommand;
import com.atlassian.stash.internal.scm.git.command.catfile.AbstractBatchCatFileStdioHandler;
import com.atlassian.stash.internal.scm.git.command.catfile.BatchHeader;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitCommand;
import com.atlassian.stash.internal.scm.git.mesh.RpcPlumbingClient;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class MeshSignedObjectsCommand
extends SimpleGitCommand<Void> {
    private static final String PGP_MESSAGE_BEGIN = "-----BEGIN PGP MESSAGE-----";
    private static final String PGP_MESSAGE_END = "-----END PGP MESSAGE-----";
    private static final String PGP_SIGNATURE_BEGIN = "-----BEGIN PGP SIGNATURE-----";
    private static final String PGP_SIGNATURE_END = "-----END PGP SIGNATURE-----";
    private static final String SSH_SIGNATURE_BEGIN = "-----BEGIN SSH SIGNATURE-----";
    private static final String SSH_SIGNATURE_END = "-----END SSH SIGNATURE-----";
    private static final String X509_MESSAGE_BEGIN = "-----BEGIN SIGNED MESSAGE-----";
    private static final String X509_MESSAGE_END = "-----END SIGNED MESSAGE-----";
    private final SignedObjectCallback callback;
    private final SignedObjectsParameters parameters;
    private final RpcPlumbingClient plumbingClient;
    private final Repository repository;

    public MeshSignedObjectsCommand(@Nonnull ExecutorService executorService, @Nonnull RpcPlumbingClient plumbingClient, @Nonnull Repository repository, @Nonnull SignedObjectCallback callback, @Nonnull SignedObjectsParameters parameters) {
        super(executorService);
        this.callback = callback;
        this.parameters = parameters;
        this.plumbingClient = plumbingClient;
        this.repository = repository;
    }

    public Void call() {
        return (Void)this.createCommand().call();
    }

    @Override
    @Nonnull
    public Future<Void> start() {
        return this.createCommand().start();
    }

    private static String matchesSignatureStart(String line) {
        switch (line) {
            case "-----BEGIN PGP SIGNATURE-----": {
                return PGP_SIGNATURE_END;
            }
            case "-----BEGIN PGP MESSAGE-----": {
                return PGP_MESSAGE_END;
            }
            case "-----BEGIN SSH SIGNATURE-----": {
                return SSH_SIGNATURE_END;
            }
            case "-----BEGIN SIGNED MESSAGE-----": {
                return X509_MESSAGE_END;
            }
        }
        return null;
    }

    private GitCommand<Void> createCommand() {
        return new MeshGitCommand<Void>(this.executorService){

            public Void call() {
                RpcCatFileBatchRequest.Builder builder = RpcCatFileBatchRequest.newBuilder();
                this.applyTimeouts(arg_0 -> ((RpcCatFileBatchRequest.Builder)builder).setTimeouts(arg_0));
                return (Void)MeshSignedObjectsCommand.this.plumbingClient.catFileBatch(MeshSignedObjectsCommand.this.repository, builder, (NioStdioHandler)new SignedObjectStdioHandler(MeshSignedObjectsCommand.this.parameters.getObjectIdSource(), MeshSignedObjectsCommand.this.callback));
            }
        };
    }

    private static class SignedObjectStdioHandler
    extends AbstractBatchCatFileStdioHandler<Void>
    implements CommandSummaryHandler {
        private final SignedObjectCallback callback;
        private final SignedObjectIdSource source;
        private String objectId;
        private ObjectParser parser;

        SignedObjectStdioHandler(SignedObjectIdSource source, SignedObjectCallback callback) {
            this.callback = callback;
            this.source = source;
        }

        public Void getOutput() {
            return null;
        }

        protected String getNextObjectId() {
            return this.source.hasNext() ? (this.objectId = this.source.next()) : null;
        }

        public void onComplete(@Nonnull CommandSummary summary) throws IOException {
            this.callback.onEnd(new SignedObjectsSummary.Builder((AbstractSummary)summary).build());
        }

        public void onStart(@Nonnull NioProcess process) {
            super.onStart(process);
            try {
                this.callback.onStart(new SignedObjectsContext.Builder().build());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected boolean onContent(@Nonnull ByteBuffer content, boolean closed) {
            if (this.parser == null) {
                return false;
            }
            try {
                this.parser.pump(content, closed);
                return true;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void onMissing(@Nonnull String objectId) {
            try {
                this.callback.onMissing(objectId);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected boolean onObject(@Nonnull BatchHeader header) {
            String type = header.getType();
            if ("commit".equals(type)) {
                this.parser = new CommitParser(this.objectId);
                return true;
            }
            if ("tag".equals(type)) {
                this.parser = new TagParser(this.objectId);
                return true;
            }
            try {
                this.callback.onUnsigned(null, header.getObjectId());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return false;
        }

        private static abstract class ObjectParser {
            protected final String objectId;
            private final LinePump pump;

            ObjectParser(String objectId) {
                this.objectId = objectId;
                this.pump = new LinePump(StandardCharsets.UTF_8, LinePump.Mode.LF);
            }

            protected abstract void onComplete() throws IOException;

            protected abstract boolean onLine(String var1, boolean var2);

            void pump(ByteBuffer buffer, boolean closed) throws IOException {
                if (this.pump.forEach(buffer, closed, this::onLine)) {
                    this.onComplete();
                }
            }
        }

        private class CommitParser
        extends ObjectParser {
            private final StringBuilder bodyBuilder;
            private boolean inHeaders;
            private boolean inSignature;
            private StringBuilder signatureBuilder;

            CommitParser(String objectId) {
                super(objectId);
                this.bodyBuilder = new StringBuilder();
                this.inHeaders = true;
            }

            @Override
            protected void onComplete() throws IOException {
                if (this.signatureBuilder == null) {
                    SignedObjectStdioHandler.this.callback.onUnsigned((SignableObjectType)StandardSignableObjectType.COMMIT, this.objectId);
                } else {
                    SignedObjectStdioHandler.this.callback.onSigned((SignableObjectType)StandardSignableObjectType.COMMIT, this.objectId, this.signatureBuilder.toString(), this.bodyBuilder.toString());
                }
            }

            @Override
            protected boolean onLine(String line, boolean truncated) {
                if (this.inSignature) {
                    if (line.startsWith(" ")) {
                        this.signatureBuilder.append(line.substring(1)).append('\n');
                        return true;
                    }
                    this.inHeaders = !line.isEmpty();
                    this.inSignature = false;
                } else if (this.inHeaders && line.startsWith("gpgsig ")) {
                    this.signatureBuilder = new StringBuilder(line.substring(7)).append('\n');
                    this.inSignature = true;
                    return true;
                }
                if (line.isEmpty()) {
                    this.inHeaders = false;
                }
                this.bodyBuilder.append(line).append('\n');
                return true;
            }
        }

        private class TagParser
        extends ObjectParser {
            private final StringBuilder bodyBuilder;
            private StringBuilder signatureBuilder;
            private String signatureEndMarker;

            TagParser(String objectId) {
                super(objectId);
                this.bodyBuilder = new StringBuilder();
            }

            @Override
            protected void onComplete() throws IOException {
                if (this.signatureBuilder == null) {
                    SignedObjectStdioHandler.this.callback.onUnsigned((SignableObjectType)StandardSignableObjectType.TAG, this.objectId);
                } else {
                    SignedObjectStdioHandler.this.callback.onSigned((SignableObjectType)StandardSignableObjectType.TAG, this.objectId, this.signatureBuilder.toString(), this.bodyBuilder.toString());
                }
            }

            @Override
            protected boolean onLine(String line, boolean truncated) {
                if (this.signatureEndMarker == null) {
                    if (this.signatureBuilder != null || (this.signatureEndMarker = MeshSignedObjectsCommand.matchesSignatureStart(line)) == null) {
                        this.bodyBuilder.append(line).append('\n');
                    } else {
                        this.signatureBuilder = new StringBuilder(line).append('\n');
                    }
                } else {
                    this.signatureBuilder.append(line).append('\n');
                    if (this.signatureEndMarker.equals(line)) {
                        this.signatureEndMarker = null;
                    }
                }
                return true;
            }
        }
    }
}

