/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionRegistry;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.mesh.MeshPartition;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationContext;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationFailedException;
import com.atlassian.bitbucket.dmz.migration.MeshMigrator;
import com.atlassian.bitbucket.dmz.migration.MigrationStep;
import com.atlassian.bitbucket.dmz.process.AbstractLineStdioHandler;
import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.dmz.server.DmzStorageService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.RepositoryIdUtils;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.migration.HierarchyMigrationState;
import com.atlassian.bitbucket.mesh.migration.MigrationStateManager;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcApplyTransactionsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitTimeouts;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcProposedRefUpdate;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcReplicaState;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetReplicaStateRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTransaction;
import com.atlassian.bitbucket.mesh.transaction.TransactionLog;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.stash.internal.scm.git.mesh.ApplyTransactionsResult;
import com.atlassian.stash.internal.scm.git.mesh.HierarchyReplicaRepairs;
import com.atlassian.stash.internal.scm.git.mesh.RpcDataClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcTransactionClient;
import com.atlassian.stash.internal.scm.git.mesh.UploadPackFileParameters;
import com.atlassian.stash.internal.scm.git.mesh.UploadSummary;
import com.atlassian.stash.internal.scm.git.transcode.TranscodeService;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timer;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import jakarta.annotation.Nonnull;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryMeshMigrator
implements MeshMigrator {
    private static final int MAX_CONCURRENT_REPAIRS = 5;
    private static final Set<Path> SUPPORTED_HOOK_PATHS = ImmutableSet.of((Object)Paths.get("post-receive", new String[0]), (Object)Paths.get("post-receive.d/20_bitbucket_callback", new String[0]), (Object)Paths.get("post-receive.d/20_stash_callback", new String[0]), (Object)Paths.get("pre-receive", new String[0]), (Object)Paths.get("pre-receive.d/20_bitbucket_callback", new String[0]), (Object)Paths.get("pre-receive.d/20_stash_callback", new String[0]), (Object[])new Path[0]);
    private static final Timer TIMER_COMPLETE = Timers.timer((String)"migration: complete");
    private static final Timer TIMER_HIERARCHY = Timers.timer((String)"migration: hierarchy");
    private static final Timer TIMER_REPAIR_REPLICAS = Timers.timer((String)"migration: repair replicas");
    private static final Timer TIMER_REPLAY = Timers.timer((String)"migration: replay concurrent writes");
    private static final Timer TIMER_STAGE = Timers.timer((String)"migration: stage repository");
    private static final Timer TIMER_UPLOAD_PACK_FILE = Timers.timer((String)"migration: upload pack file");
    private static final int TRANSACTION_BATCH_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(RepositoryMeshMigrator.class);
    private final GitCommandBuilderFactory builderFactory;
    private final RpcDataClient dataClient;
    private final I18nService i18nService;
    private final RpcManagementClient managementClient;
    private final DmzMeshService meshService;
    private final MigrationStateManager migrationStateManager;
    private final DmzMeshPartitionRegistry partitionRegistry;
    private final RepositorySupplier repositorySupplier;
    private final DmzStorageService storageService;
    private final RpcTransactionClient transactionClient;
    private final TranscodeService transcodeService;

    public RepositoryMeshMigrator(GitCommandBuilderFactory builderFactory, RpcDataClient dataClient, I18nService i18nService, RpcManagementClient managementClient, DmzMeshService meshService, MigrationStateManager migrationStateManager, DmzMeshPartitionRegistry partitionRegistry, RepositorySupplier repositorySupplier, DmzStorageService storageService, RpcTransactionClient transactionClient, TranscodeService transcodeService) {
        this.builderFactory = builderFactory;
        this.dataClient = dataClient;
        this.i18nService = i18nService;
        this.managementClient = managementClient;
        this.meshService = meshService;
        this.migrationStateManager = migrationStateManager;
        this.partitionRegistry = partitionRegistry;
        this.repositorySupplier = repositorySupplier;
        this.storageService = storageService;
        this.transactionClient = transactionClient;
        this.transcodeService = transcodeService;
    }

    public MeshMigrator.HierarchyMigration startHierarchy(@Nonnull MeshMigrationContext context, @Nonnull String hierarchyId, int partition) {
        return new GitHierarchyMigration(context, hierarchyId, partition);
    }

    private class GitHierarchyMigration
    implements MeshMigrator.HierarchyMigration,
    TransactionLog.Processor {
        private final MeshMigrationContext context;
        private final HierarchyMigrationState hierarchyMigrationState;
        private final String hierarchyId;
        private final MeshNode primaryNode;
        private final HierarchyReplicaRepairs repairs;
        private final Ticker ticker;
        private DmzRepository uploadPackFileDestination;

        GitHierarchyMigration(MeshMigrationContext context, String hierarchyId, int partition) {
            this.context = Objects.requireNonNull(context, "context");
            this.hierarchyId = Objects.requireNonNull(hierarchyId, "hierarchyId");
            MeshPartition meshPartition = (MeshPartition)RepositoryMeshMigrator.this.partitionRegistry.getPartition(partition).orElseThrow(() -> new IllegalStateException("Partition " + partition + " not found"));
            this.primaryNode = meshPartition.getReplicas().stream().map(MeshPartitionReplica::getNode).filter(MeshNode::isAvailable).findFirst().orElseThrow(() -> new IllegalStateException("All partition replicas are offline"));
            List secondaryNodes = (List)meshPartition.getReplicas().stream().map(MeshPartitionReplica::getNode).filter(node -> node.getId() != this.primaryNode.getId()).collect(MoreCollectors.toImmutableList());
            this.repairs = new HierarchyReplicaRepairs(RepositoryMeshMigrator.this.managementClient, 5, this.primaryNode, secondaryNodes);
            log.debug("[{}] Starting tracking of write operations", (Object)hierarchyId);
            this.hierarchyMigrationState = this.startTrackingWrites(hierarchyId, partition);
            this.ticker = TIMER_HIERARCHY.start(new String[]{hierarchyId});
        }

        public void abort() {
            try {
                this.repairs.cancel();
                this.hierarchyMigrationState.stop(false);
                this.hierarchyMigrationState.clear(false);
            }
            finally {
                this.ticker.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete(@Nonnull MigrationStep step) {
            try {
                try (Ticker ignored = TIMER_REPAIR_REPLICAS.start(new String[0]);){
                    this.repairs.await();
                }
                try {
                    ignored = TIMER_COMPLETE.start(new String[0]);
                    try {
                        this.hierarchyMigrationState.getTransactionLog().process((TransactionLog.Processor)this, 100);
                        this.hierarchyMigrationState.stop(true);
                        this.hierarchyMigrationState.getTransactionLog().process((TransactionLog.Processor)this, 100);
                        this.hierarchyMigrationState.clear(false);
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                catch (RuntimeException e) {
                    this.hierarchyMigrationState.stop(false);
                    throw e;
                }
            }
            finally {
                this.ticker.close();
            }
        }

        @Nonnull
        public TransactionLog.Result process(@Nonnull List<RpcTransaction> transactions) {
            this.uploadPack(transactions);
            if (this.uploadPackFileDestination == null) {
                return TransactionLog.Result.proceed();
            }
            try (Ticker ignored = TIMER_REPLAY.start(new Object[]{transactions.size()});){
                ApplyTransactionsResult rpcResult = RepositoryMeshMigrator.this.transactionClient.applyTransactions(this.primaryNode, (Repository)this.uploadPackFileDestination, RpcApplyTransactionsRequest.newBuilder().addAllTransactions(transactions).setTimeouts(RpcGitTimeouts.newBuilder().setExecution(TimeUnit.MINUTES.toMillis(5L))));
                TransactionLog.Result result = rpcResult.getException().map(exception -> TransactionLog.Result.error((int)rpcResult.getUnprocessedCount(), (Exception)exception)).orElse(TransactionLog.Result.proceed());
                if (result.isError()) {
                    log.warn("[{}] Failed to replay {} of {} transactions", new Object[]{this.hierarchyId, result.getUnprocessed(), transactions.size(), rpcResult.getException().orElse(null)});
                } else {
                    log.debug("[{}] Replayed {} transactions", (Object)this.hierarchyId, (Object)transactions.size());
                }
                TransactionLog.Result result2 = result;
                return result2;
            }
        }

        public void stage(@Nonnull Repository sourceRepository, @Nonnull DmzRepository destinationRepository, @Nonnull MigrationStep step) {
            try (Ticker ignored = TIMER_STAGE.start(new Object[]{sourceRepository});){
                if (this.uploadPackFileDestination == null) {
                    this.uploadPackFileDestination = destinationRepository;
                }
                RepositoryMeshMigrator.this.managementClient.setReplicaState(this.primaryNode, (Repository)destinationRepository, RpcSetReplicaStateRequest.newBuilder().setReplicaState(RpcReplicaState.REPLICA_STATE_CONSISTENT));
                if (RepositoryMeshMigrator.this.transcodeService.isEnabled(sourceRepository)) {
                    RepositoryMeshMigrator.this.transcodeService.setEnabled((Repository)destinationRepository, true);
                }
                MeshNode sidecar = (MeshNode)RepositoryMeshMigrator.this.meshService.getSidecar().orElseThrow(() -> new IllegalStateException("Sidecar not found"));
                this.repairFromSidecar(sidecar, sourceRepository, (Repository)destinationRepository, step);
                this.repairs.startReplicaRepairs((Repository)destinationRepository);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private HeadsIterator getHeadsForAncestors(Collection<Repository> repositories) {
            HashSet<Repository> excludes = new HashSet<Repository>(repositories);
            for (Repository repository : repositories) {
                for (Repository origin = repository.getOrigin(); origin != null; origin = origin.getOrigin()) {
                    excludes.add(origin);
                }
            }
            return new HeadsIterator(this::getHeadsPath, excludes.iterator());
        }

        private Path getHeadsPath(Repository repository) {
            return this.hierarchyMigrationState.getTmpDir().resolve("heads-" + repository.getId() + ".dat");
        }

        private Path getPackedRefsPath(Repository repository) {
            return this.hierarchyMigrationState.getTmpDir().resolve(repository.getId() + "-packed-refs");
        }

        private void repairFromSidecar(MeshNode sidecar, Repository sourceRepository, Repository destinationRepository, MigrationStep step) throws IOException {
            Path repositoryDir = RepositoryMeshMigrator.this.storageService.getRepositoryDir(sourceRepository);
            this.warnIfNonStandardHookScriptsFound(repositoryDir, sourceRepository);
            this.recordHeadsAndCreatePackedRefs(sourceRepository);
            log.debug("[{}] Instructing the sidecar to repair the replica on {}", (Object)destinationRepository, (Object)this.primaryNode);
            try {
                if (!((Boolean)RepositoryMeshMigrator.this.managementClient.repairRepository(sidecar, this.primaryNode, sourceRepository, destinationRepository).get()).booleanValue()) {
                    log.debug("[{}] One or more concurrent writes were detected while the primary Mesh repository was initialized. These writes will be replayed at the end of the hierarchy migration.", (Object)sourceRepository);
                }
                step.updateProgress(100.0);
            }
            catch (CancellationException | ExecutionException e) {
                Throwable cause = e.getCause();
                throw new MeshMigrationFailedException(String.format("[%s] Sidecar failed to repair the primary Mesh repository. Aborting migration", sourceRepository), cause == null ? e : cause);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MeshMigrationFailedException("Interrupted or cancelled waiting for " + String.valueOf(sourceRepository) + " repairs to complete");
            }
        }

        private HierarchyMigrationState startTrackingWrites(String hierarchyId, int partition) {
            try {
                HierarchyMigrationState state = RepositoryMeshMigrator.this.migrationStateManager.createForHierarchy(hierarchyId, partition);
                state.start();
                return state;
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot enable write tracking for hierarchy " + hierarchyId, e);
            }
        }

        private void uploadPack(List<RpcTransaction> transactions) {
            block16: {
                try (Ticker ignored = TIMER_UPLOAD_PACK_FILE.start(new String[0]);){
                    ImmutableSet.Builder includesBuilder = ImmutableSet.builder();
                    HashMap<String, Repository> sourcesCache = new HashMap<String, Repository>();
                    for (RpcTransaction transaction : transactions) {
                        if (!transaction.hasUpdateRefs()) continue;
                        sourcesCache.computeIfAbsent(transaction.getRepository(), remoteId -> {
                            int id = RepositoryIdUtils.getLocalRepositoryId((String)remoteId);
                            if (id != -1) {
                                return RepositoryMeshMigrator.this.repositorySupplier.getById(id);
                            }
                            return null;
                        });
                        for (RpcProposedRefUpdate refUpdate : transaction.getUpdateRefs().getRefUpdatesList()) {
                            String newHash = refUpdate.getNewHash();
                            if (!StringUtils.isNotBlank((CharSequence)newHash) || ShaUtils.hashesMatch((String)ShaUtils.NULL_SHA1, (String)newHash)) continue;
                            includesBuilder.add((Object)newHash);
                        }
                    }
                    ImmutableSet includes = includesBuilder.build();
                    if (includes.isEmpty() || sourcesCache.isEmpty()) break block16;
                    try (Closer closer = Closer.create();){
                        Collection sources = sourcesCache.values();
                        UploadSummary summary = RepositoryMeshMigrator.this.dataClient.uploadPackFile(this.primaryNode, (Repository)this.uploadPackFileDestination, new UploadPackFileParameters.Builder().sources(sources).includes((Iterable)includes).excludes(() -> {
                            HeadsIterator excludesIterator = this.getHeadsForAncestors(sources);
                            closer.register((Closeable)excludesIterator);
                            return excludesIterator;
                        }).build());
                        log.debug("[{}] Uploaded {} byte pack file to {}", new Object[]{this.hierarchyId, summary.getByteCount(), this.primaryNode});
                    }
                    catch (IOException e) {
                        log.debug("Could close heads iterator", (Throwable)e);
                    }
                }
            }
        }

        @Nonnull
        private Path recordHeadsAndCreatePackedRefs(Repository source) throws IOException {
            Path packedRefsPath = this.getPackedRefsPath(source);
            Path headsPath = this.getHeadsPath(source);
            ((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)RepositoryMeshMigrator.this.builderFactory.builder(source).command("ls-remote")).argument("-q")).argument(".")).build((CommandOutputHandler)new WritePackedRefsAndHeadsHandler(headsPath, packedRefsPath)).call();
            return packedRefsPath;
        }

        private void warnIfNonStandardHookScriptsFound(Path repositoryDir, Repository repository) {
            Path hooksDir = repositoryDir.resolve("hooks");
            try (Stream<Path> hookScripts = Files.walk(hooksDir, 3, new FileVisitOption[0]);){
                String nonStandardScripts = hookScripts.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> !path.getFileName().toString().contains(".")).map(hooksDir::relativize).filter(path -> !SUPPORTED_HOOK_PATHS.contains(path)).map(Path::toString).collect(Collectors.joining(", "));
                if (StringUtils.isNotBlank((CharSequence)nonStandardScripts)) {
                    this.context.addWarning(RepositoryMeshMigrator.this.i18nService.createKeyedMessage("bitbucket.git.mesh.migration.non.standard.hook.scripts.skipped", new Object[]{nonStandardScripts}), (Object)repository);
                }
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                log.debug("[{}] Check for non-standard hook scripts failed; no hooks dir found", (Object)repository);
            }
            catch (IOException e) {
                log.info("[{}] Check for non-standard hook scripts failed", (Object)repository, (Object)e);
            }
        }
    }

    private static class HeadsIterator
    implements Iterator<String>,
    Closeable {
        private final Function<Repository, Path> pathResolver;
        private final Iterator<Repository> repositoryIterator;
        private LineIterator headsIterator;

        HeadsIterator(Function<Repository, Path> pathResolver, Iterator<Repository> repositoryIterator) {
            this.pathResolver = pathResolver;
            this.repositoryIterator = repositoryIterator;
        }

        @Override
        public void close() throws IOException {
            LineIterator headsIterator = this.headsIterator;
            if (headsIterator != null) {
                headsIterator.close();
            }
        }

        @Override
        public boolean hasNext() {
            while ((this.headsIterator == null || !this.headsIterator.hasNext()) && this.repositoryIterator.hasNext()) {
                if (this.headsIterator != null) {
                    try {
                        this.headsIterator.close();
                    }
                    catch (IOException e) {
                        log.debug("Error closing heads iterator", (Throwable)e);
                    }
                }
                Repository next = this.repositoryIterator.next();
                log.trace("Iterating over heads of {}", (Object)next);
                this.headsIterator = this.getHeadsIterator(next);
            }
            return this.headsIterator != null && this.headsIterator.hasNext();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("iterator is depleted");
            }
            return this.headsIterator.next();
        }

        private LineIterator getHeadsIterator(Repository repository) {
            try {
                return FileUtils.lineIterator((File)this.pathResolver.apply(repository).toFile(), (String)"UTF-8");
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                return new LineIterator((Reader)new StringReader(""));
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot open heads file for " + String.valueOf(repository), e);
            }
        }
    }

    private static class WritePackedRefsAndHeadsHandler
    extends AbstractLineStdioHandler<Void> {
        private static final Pattern PATTERN = Pattern.compile("([0-9a-f]{40,})\\s+([^\\^]+)(\\^\\{})?");
        private final BufferedWriter heads;
        private final BufferedWriter packedRefs;
        private boolean checkHead = true;

        WritePackedRefsAndHeadsHandler(Path headsPath, Path packedRefsPath) throws IOException {
            super(StandardCharsets.UTF_8);
            this.heads = Files.newBufferedWriter(headsPath, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            this.packedRefs = Files.newBufferedWriter(packedRefsPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            this.packedRefs.write("# pack-refs with: peeled fully-peeled sorted\n");
        }

        public Void getOutput() {
            return null;
        }

        protected boolean onStdout(@Nonnull String line, boolean truncated) {
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                String refId = matcher.group(2);
                if (this.checkHead) {
                    this.checkHead = false;
                    if ("HEAD".equals(refId)) {
                        return true;
                    }
                }
                String hash = matcher.group(1);
                try {
                    this.heads.write(hash);
                    this.heads.write(10);
                    if (matcher.group(3) == null) {
                        this.packedRefs.write(hash);
                        this.packedRefs.write(32);
                        this.packedRefs.write(refId);
                    } else {
                        this.packedRefs.write(94);
                        this.packedRefs.write(hash);
                    }
                    this.packedRefs.write(10);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return true;
        }

        protected void onStdoutClosed() {
            try (Closer closer = Closer.create();){
                closer.register((Closeable)this.heads);
                closer.register((Closeable)this.packedRefs);
            }
            catch (IOException e) {
                log.warn("Failed to close output", (Throwable)e);
            }
        }
    }
}

