/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh.command.clone;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.clone.CloneFormat;
import com.atlassian.stash.internal.scm.git.command.clone.DefaultGitCloneBuilder;
import com.atlassian.stash.internal.scm.git.command.clone.GitCloneBuilder;
import com.atlassian.stash.internal.scm.git.mesh.MeshRepositoryArgumentCodec;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;

public class MeshGitCloneBuilder
extends DefaultGitCloneBuilder {
    private final MeshRepositoryArgumentCodec argumentCodec;

    public MeshGitCloneBuilder(MeshRepositoryArgumentCodec argumentCodec, GitFreeFormCommandBuilder builder, GitScmConfig config, CloneFormat format) {
        super(builder, config, format);
        this.argumentCodec = argumentCodec;
    }

    @Override
    @Nonnull
    public GitCloneBuilder origin(@Nonnull File file) {
        return super.origin(this.argumentCodec.encode(Objects.requireNonNull(file, "file").getPath()));
    }

    @Override
    @Nonnull
    public GitCloneBuilder origin(@Nonnull Path path) {
        return super.origin(this.argumentCodec.encode(Objects.requireNonNull(path, "path")));
    }

    @Override
    @Nonnull
    public GitCloneBuilder origin(@Nonnull Repository repository) {
        return super.origin(this.argumentCodec.encode(Objects.requireNonNull(repository, "repository")));
    }
}

