/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh.command.remote;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.remote.GitRemoteAddBuilder;
import com.atlassian.bitbucket.scm.git.command.remote.GitRemoteSetUrlBuilder;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.remote.DefaultGitRemote;
import com.atlassian.stash.internal.scm.git.command.remote.DefaultGitRemoteAddBuilder;
import com.atlassian.stash.internal.scm.git.command.remote.DefaultGitRemoteSetUrlBuilder;
import com.atlassian.stash.internal.scm.git.mesh.MeshRepositoryArgumentCodec;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;

public class MeshGitRemote
extends DefaultGitRemote {
    private final MeshRepositoryArgumentCodec argumentCodec;
    private final GitFreeFormCommandBuilder builder;

    public MeshGitRemote(MeshRepositoryArgumentCodec argumentCodec, GitFreeFormCommandBuilder builder, GitScmConfig config) {
        super(builder, config);
        this.argumentCodec = argumentCodec;
        this.builder = (GitFreeFormCommandBuilder)builder.command("remote");
    }

    @Override
    @Nonnull
    public GitRemoteAddBuilder add(@Nonnull String name, @Nonnull Path url) {
        return new DefaultGitRemoteAddBuilder(this.builder, name, this.argumentCodec.encode(url));
    }

    @Override
    @Nonnull
    public GitRemoteAddBuilder add(@Nonnull String name, @Nonnull Repository repository) {
        return new DefaultGitRemoteAddBuilder(this.builder, name, this.argumentCodec.encode(repository));
    }

    @Override
    @Nonnull
    public GitRemoteSetUrlBuilder setUrl(@Nonnull String name, @Nonnull Path newUrl) {
        return new DefaultGitRemoteSetUrlBuilder(this.builder, name, this.argumentCodec.encode(newUrl));
    }
}

