/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh.command.worktree;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.git.command.GitWorkTreeCommandBuilder;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTree;
import com.atlassian.stash.internal.scm.git.GitCommandCreator;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.DefaultGitWorkTreeCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitCommandBuilderConfigurer;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitWorkTreeCommandBuilderFactory;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshGitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.mesh.MeshRepositoryArgumentCodec;
import com.atlassian.stash.internal.scm.git.mesh.RpcPlumbingClient;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

public class MeshGitWorkTreeCommandBuilderFactory
implements GitWorkTreeCommandBuilderFactory {
    private final MeshRepositoryArgumentCodec argumentCodec;
    private final ThreadPoolExecutor bioExecutor;
    private final GitCommandCreator commandCreator;
    private final GitScmConfig config;
    private final List<GitCommandBuilderConfigurer> configurers;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RpcPlumbingClient plumbingClient;
    private final GitRequestHelper requestHelper;

    public MeshGitWorkTreeCommandBuilderFactory(MeshRepositoryArgumentCodec argumentCodec, ExecutorService executorService, GitCommandCreator commandCreator, GitScmConfig config, GitRequestHelper requestHelper, I18nService i18nService, List<GitCommandBuilderConfigurer> configurers, ThreadPoolExecutor bioExecutor, RpcPlumbingClient plumbingClient) {
        this.argumentCodec = argumentCodec;
        this.bioExecutor = bioExecutor;
        this.commandCreator = commandCreator;
        this.config = config;
        this.configurers = ImmutableList.copyOf(configurers);
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.plumbingClient = plumbingClient;
        this.requestHelper = requestHelper;
    }

    @Override
    @Nonnull
    public GitWorkTreeCommandBuilder builder(@Nonnull GitWorkTree workTree) {
        Objects.requireNonNull(workTree, "workTree");
        return new DefaultGitWorkTreeCommandBuilder(this.freeFormBuilder(workTree), this.config, this.i18nService, null);
    }

    @Nonnull
    protected GitFreeFormCommandBuilder configure(@Nonnull GitFreeFormCommandBuilder builder) {
        Objects.requireNonNull(builder, "builder");
        for (GitCommandBuilderConfigurer configurer : this.configurers) {
            configurer.configure(builder);
        }
        return builder;
    }

    @Nonnull
    protected GitFreeFormCommandBuilder freeFormBuilder(@Nonnull GitWorkTree workTree) {
        return this.configure(new MeshGitFreeFormCommandBuilder(this.i18nService, this.commandCreator, this.config, (ExecutorService)this.bioExecutor, this.executorService, this.plumbingClient, workTree, this.requestHelper, this.argumentCodec));
    }
}

